/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class ProjectRapidViewServiceImpl
implements ProjectRapidViewService {
    @Autowired
    private QueryService queryService;
    @Autowired
    private RapidViewManager rapidViewManager;

    @Override
    @Nonnull
    public ServiceOutcome<List<RapidView>> findRapidViewsByProject(@Nullable ApplicationUser user, Project project) {
        ServiceOutcome<List<RapidView>> unfilteredRapidViews = this.rapidViewManager.getAll();
        if (unfilteredRapidViews.isInvalid()) {
            return unfilteredRapidViews;
        }
        ArrayList projectRapidViews = Lists.newArrayList();
        for (RapidView rapidView : unfilteredRapidViews.get()) {
            if (!this.projectBelongsToRapidView(user, rapidView, project)) continue;
            projectRapidViews.add(rapidView);
        }
        return ServiceOutcomeImpl.ok(projectRapidViews);
    }

    private boolean projectBelongsToRapidView(ApplicationUser applicationUser, RapidView rapidView, Project project) {
        return this.queryService.projectBelongsToRapidView(applicationUser, rapidView, project).fold(e -> false, Function.identity());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<Project>> findProjectsByRapidView(@Nullable ApplicationUser user, RapidView rapidView) {
        return this.queryService.getExplicitProjectsForRapidViewFilterQuery(user, rapidView);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Page<Project>> findProjectsByRapidView(@Nullable ApplicationUser user, RapidView rapidView, PageRequest pageRequest) {
        ServiceOutcome<Set<Project>> projectsByRapidView = this.findProjectsByRapidView(user, rapidView);
        if (projectsByRapidView.isInvalid()) {
            return ServiceOutcomeImpl.error(projectsByRapidView);
        }
        Set<Project> projects = projectsByRapidView.get();
        Stream sortedProjects = projects.stream().sorted(ProjectNameComparator.COMPARATOR);
        return ServiceOutcomeImpl.ok(Pages.toPage(sortedProjects::iterator, pageRequest, Long.valueOf(projects.size())));
    }
}

