/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.JpoPreconditionChecker;
import com.atlassian.greenhopper.service.rank.JpoRankOperationPreparer;
import com.atlassian.greenhopper.service.rank.JpoRankOperations;
import com.atlassian.greenhopper.service.rank.RankChangesResult;
import com.atlassian.greenhopper.service.rank.RankOperationPreparationResult;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RecursiveRankOperations
implements JpoRankOperations {
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private JpoPreconditionChecker preconditionChecker;
    @Autowired
    private JpoRankOperationPreparer operationPreparer;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private IssueIndexService issueIndexService;

    RecursiveRankOperations() {
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankBefore(List<Long> ids, long anchorId, long domain, ApplicationUser user) {
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankOperationPreconditions(domain, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        RankOperationPreparationResult preparation = this.operationPreparer.prepareRankOperation(ids, domain, user);
        RankChangesResult.Builder resultBuilder = RankChangesResult.builder(preparation);
        this.rankBeforeRecursively(anchorId, preparation.getRankableIds(), domain, user, resultBuilder);
        return ServiceOutcomeImpl.ok(resultBuilder.build());
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankAfter(List<Long> ids, long anchorId, long domain, ApplicationUser user) {
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankOperationPreconditions(domain, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        RankOperationPreparationResult preparation = this.operationPreparer.prepareRankOperation(ids, domain, user);
        RankChangesResult.Builder resultBuilder = RankChangesResult.builder(preparation);
        this.rankAfterRecursively(anchorId, preparation.getRankableIds(), domain, user, resultBuilder);
        return ServiceOutcomeImpl.ok(resultBuilder.build());
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankFirst(List<Long> ids, long domain, ApplicationUser user) {
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankOperationPreconditions(domain, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        RankOperationPreparationResult preparation = this.operationPreparer.prepareRankOperation(ids, domain, user);
        RankChangesResult.Builder resultBuilder = RankChangesResult.builder(preparation);
        if (preparation.getRankableIds().isEmpty()) {
            return ServiceOutcomeImpl.ok(resultBuilder.build());
        }
        if (this.storeRankFirst(this.getPivotElement(preparation.getRankableIds()), domain, user, resultBuilder)) {
            this.traverse(preparation.getRankableIds(), domain, user, resultBuilder);
        }
        return ServiceOutcomeImpl.ok(resultBuilder.build());
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankLast(List<Long> ids, long domain, ApplicationUser user) {
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankOperationPreconditions(domain, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        RankOperationPreparationResult preparation = this.operationPreparer.prepareRankOperation(ids, domain, user);
        RankChangesResult.Builder resultBuilder = RankChangesResult.builder(preparation);
        if (preparation.getRankableIds().isEmpty()) {
            return ServiceOutcomeImpl.ok(resultBuilder.build());
        }
        if (this.storeRankLast(this.getPivotElement(preparation.getRankableIds()), domain, user, resultBuilder)) {
            this.traverse(preparation.getRankableIds(), domain, user, resultBuilder);
        }
        return ServiceOutcomeImpl.ok(resultBuilder.build());
    }

    private void rankAfterRecursively(long anchorId, List<Long> ids, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.storeRankAfter(this.getPivotElement(ids), anchorId, domain, user, resultBuilder)) {
            this.traverse(ids, domain, user, resultBuilder);
        }
    }

    private void rankBeforeRecursively(long anchorId, List<Long> ids, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.storeRankBefore(this.getPivotElement(ids), anchorId, domain, user, resultBuilder)) {
            this.traverse(ids, domain, user, resultBuilder);
        }
    }

    private void traverse(List<Long> ids, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        int pivot = this.getPivotIndex(ids);
        this.rankBeforeRecursively(ids.get(pivot), ids.subList(0, pivot), domain, user, resultBuilder);
        if (pivot < ids.size() - 1) {
            this.rankAfterRecursively(ids.get(pivot), ids.subList(pivot + 1, ids.size()), domain, user, resultBuilder);
        }
    }

    private long getPivotElement(List<Long> ids) {
        return ids.get(this.getPivotIndex(ids));
    }

    private int getPivotIndex(List<Long> ids) {
        return (ids.size() - 1) / 2;
    }

    private boolean storeRankBefore(long id, long anchorId, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        LexoRankOperationOutcome<LexoRankChange> lexoOutcome = this.lexoRankManager.rankBefore(domain, id, anchorId);
        return this.processLexoRankChange(id, lexoOutcome, user, resultBuilder);
    }

    private boolean storeRankAfter(long id, long anchorId, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        LexoRankOperationOutcome<LexoRankChange> lexoOutcome = this.lexoRankManager.rankAfter(domain, id, anchorId);
        return this.processLexoRankChange(id, lexoOutcome, user, resultBuilder);
    }

    private boolean storeRankFirst(long id, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        LexoRankOperationOutcome<LexoRankChange> lexoOutcome = this.lexoRankManager.rankFirst(domain, id);
        return this.processLexoRankChange(id, lexoOutcome, user, resultBuilder);
    }

    private boolean storeRankLast(long id, long domain, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        LexoRankOperationOutcome<LexoRankChange> lexoOutcome = this.lexoRankManager.rankLast(domain, id);
        return this.processLexoRankChange(id, lexoOutcome, user, resultBuilder);
    }

    private boolean processLexoRankChange(long id, LexoRankOperationOutcome<LexoRankChange> change, ApplicationUser user, RankChangesResult.Builder resultBuilder) {
        if (!change.isValid()) {
            resultBuilder.addError(id, change.getErrors());
            return false;
        }
        resultBuilder.addSuccessfulChange(change.getResult());
        this.issueIndexService.reindexIssuesAndSubtasks(change.getIssueIdsToReIndex());
        if (this.isRealIssue(id)) {
            this.rankCustomFieldService.addChangeItem(user, change.getResult());
        }
        return true;
    }

    private boolean isRealIssue(long id) {
        return id >= 0L;
    }
}

