/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.manager.rankableobject.RankableObjectManager;
import com.atlassian.greenhopper.model.rapid.RankableObject;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankableObjectService {
    @Autowired
    private RankableObjectManager rankableObjectManager;

    public ServiceOutcome<RankableObject> createRankableObject(ApplicationUser user, String type) {
        if ("issue".equals(type)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "RankableObject type must not be \"issue\"", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "RankableObject type must be specified", new Object[0]);
        }
        RankableObject rankableObject = RankableObject.builder().type(type).build();
        return this.rankableObjectManager.createRankableObject(rankableObject);
    }

    public ServiceOutcome<Void> deleteRankableObject(ApplicationUser user, RankableObject rankableObject) {
        return this.rankableObjectManager.deleteRankableObject(rankableObject);
    }

    public ServiceOutcome<RankableObject> getRankableObject(ApplicationUser user, long id) {
        return this.rankableObjectManager.getRankableObject(id);
    }
}

