/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.model.rapid.RankableObject;
import com.atlassian.jira.issue.Issue;
import org.apache.commons.lang3.StringUtils;

public class RankableImpl
implements Rankable {
    private Issue issue;
    private boolean issueLoaded;
    private RankableObject rankableObject;
    private String type;
    private long id;

    public RankableImpl(String type, Long id) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new IllegalArgumentException("Rankable type must not be empty");
        }
        this.type = type;
        if (id == null) {
            throw new IllegalArgumentException("Rankable id must not be null");
        }
        this.id = id;
    }

    public RankableImpl(Issue issue) {
        this("issue", issue.getId());
        this.issue = issue;
        this.issueLoaded = true;
    }

    public RankableImpl(RankableObject rankableObject) {
        this(rankableObject.getType(), rankableObject.getId());
        this.rankableObject = rankableObject;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public RankableObject getRankableObject() {
        return this.rankableObject;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isIssue() {
        return "issue".equals(this.type);
    }

    public boolean isRankableObject() {
        return !this.isIssue();
    }

    public long getRankIndexId() {
        return this.isIssue() ? this.getId() : -1L * this.getId();
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
        this.id = issue.getId();
        this.type = "issue";
        this.issueLoaded = true;
    }

    public boolean isIssueLoaded() {
        return this.issueLoaded;
    }

    public void setIssueLoaded(boolean issueLoaded) {
        this.issueLoaded = issueLoaded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankableImpl rankable = (RankableImpl)o;
        if (this.id != rankable.id) {
            return false;
        }
        return this.type.equals(rankable.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

