/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.model.rapid.RankableObject;
import com.atlassian.greenhopper.service.rank.RankableImpl;
import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RankableFactory {
    public Rankable fromIssue(Issue issue) {
        return new RankableImpl(issue);
    }

    public List<Rankable> fromIssues(Collection<Issue> issues) {
        ArrayList rankables = Lists.newArrayList();
        for (Issue issue : issues) {
            rankables.add(this.fromIssue(issue));
        }
        return rankables;
    }

    public Rankable fromRankableObject(RankableObject object) {
        return new RankableImpl(object);
    }

    public Rankable fromTypeAndId(String type, long id) {
        return new RankableImpl(type, id);
    }
}

