/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.rank.FlatLexoRankableComparator;
import com.atlassian.greenhopper.service.rank.RankChangesOutcomeImpl;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="greenhopper-rank-service-internal")
public class RankServiceImpl
implements RankService {
    private static final int NO_REMAINING_RANK_OPERATIONS = 0;
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private IssueIndexService issueIndexService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankBefore(ApplicationUser user, long customFieldId, Rankable rankable, Rankable rankBefore) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankable), rankField -> this.doRankBefore(user, (CustomField)rankField, rankable, rankBefore, 0));
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChangesOutcome> rankBefore(final ApplicationUser user, long customFieldId, final List<Rankable> rankables, final Rankable rankBefore) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankables), new Function<CustomField, ServiceOutcome<RankChangesOutcome>>(){

            public ServiceOutcome<RankChangesOutcome> apply(CustomField rankField) {
                return RankServiceImpl.this.doRankBefore(user, rankField, rankables, rankBefore);
            }
        });
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankAfter(ApplicationUser user, long customFieldId, Rankable rankable, Rankable rankAfter) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankable), rankField -> this.doRankAfter(user, (CustomField)rankField, rankable, rankAfter, 0));
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChangesOutcome> rankAfter(final ApplicationUser user, long customFieldId, final List<Rankable> rankables, final Rankable rankAfter) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankables), new Function<CustomField, ServiceOutcome<RankChangesOutcome>>(){

            public ServiceOutcome<RankChangesOutcome> apply(@Nullable CustomField rankField) {
                return RankServiceImpl.this.doRankAfter(user, rankField, rankables, rankAfter);
            }
        });
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankFirst(final ApplicationUser user, long customFieldId, final Rankable rankable) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankable), new Function<CustomField, ServiceOutcome<RankChange>>(){

            public ServiceOutcome<RankChange> apply(@Nullable CustomField rankField) {
                return RankServiceImpl.this.doRankFirst(user, rankField, rankable);
            }
        });
    }

    @Override
    public ServiceOutcome<RankChangesOutcome> rankFirst(ApplicationUser user, long customFieldId, List<Rankable> rankables) {
        ServiceOutcome<CustomField> rankFieldOutcome = this.getRankFieldAndCheckPermission(user, customFieldId, rankables);
        if (rankFieldOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rankFieldOutcome);
        }
        if (rankables.isEmpty()) {
            return ServiceOutcomeImpl.ok();
        }
        Rankable firstRankable = rankables.get(0);
        ServiceOutcome<RankChange> firstRankOutcome = this.doRankFirst(user, rankFieldOutcome.getValue(), firstRankable);
        if (firstRankOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(firstRankOutcome);
        }
        List<Rankable> nextRankables = rankables.subList(1, rankables.size());
        ServiceOutcome<RankChangesOutcome> nextRankOutcome = this.doRankAfter(user, rankFieldOutcome.getValue(), nextRankables, firstRankable);
        if (nextRankOutcome.isInvalid()) {
            return nextRankOutcome;
        }
        RankChangesOutcomeImpl.Builder allChanges = RankChangesOutcomeImpl.builder();
        allChanges.addSuccessfulChange(firstRankOutcome.getValue());
        allChanges.addSuccessfulChanges(nextRankOutcome.getValue().getSuccessfulRankChanges());
        allChanges.addErrorCollections(nextRankOutcome.getValue().getErrorCollections());
        return ServiceOutcomeImpl.ok(allChanges.build());
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankLast(final ApplicationUser user, long customFieldId, final Rankable rankable) {
        return ServiceOutcomes.flatMap(this.getRankFieldAndCheckPermission(user, customFieldId, rankable), new Function<CustomField, ServiceOutcome<RankChange>>(){

            public ServiceOutcome<RankChange> apply(@Nullable CustomField rankField) {
                return RankServiceImpl.this.doRankLast(user, rankField, rankable);
            }
        });
    }

    @Override
    public ServiceOutcome<RankChangesOutcome> rankLast(ApplicationUser user, long customFieldId, List<Rankable> rankables) {
        ServiceOutcome<CustomField> rankFieldOutcome = this.getRankFieldAndCheckPermission(user, customFieldId, rankables);
        if (rankFieldOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rankFieldOutcome);
        }
        if (rankables.isEmpty()) {
            return ServiceOutcomeImpl.ok();
        }
        Rankable firstRankable = rankables.get(0);
        ServiceOutcome<RankChange> firstRankOutcome = this.doRankLast(user, rankFieldOutcome.getValue(), firstRankable);
        if (firstRankOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(firstRankOutcome);
        }
        List<Rankable> nextRankables = rankables.subList(1, rankables.size());
        ServiceOutcome<RankChangesOutcome> nextRankOutcome = this.doRankAfter(user, rankFieldOutcome.getValue(), nextRankables, firstRankable);
        if (nextRankOutcome.isInvalid()) {
            return nextRankOutcome;
        }
        RankChangesOutcomeImpl.Builder allChanges = RankChangesOutcomeImpl.builder();
        allChanges.addSuccessfulChange(firstRankOutcome.getValue());
        allChanges.addSuccessfulChanges(nextRankOutcome.getValue().getSuccessfulRankChanges());
        allChanges.addErrorCollections(nextRankOutcome.getValue().getErrorCollections());
        return ServiceOutcomeImpl.ok(allChanges.build());
    }

    @Nonnull
    private ServiceOutcome<RankChange> doRankBefore(ApplicationUser user, CustomField rankField, Rankable rankable, Rankable rankBefore, int remainingRankOperations) {
        LexoRankOperationOutcome<LexoRankChange> rankOutcome = this.lexoRankManager.rankBefore(rankField.getIdAsLong(), rankable.getId(), rankBefore.getId(), remainingRankOperations);
        return this.updateIssueHistoryAndReindexAffectedIssues(user, rankOutcome);
    }

    private ServiceOutcome<RankChangesOutcome> doRankBefore(ApplicationUser user, CustomField rankField, List<Rankable> rankables, Rankable rankBefore) {
        RankChangesOutcomeImpl.Builder rankChangesOutcome = RankChangesOutcomeImpl.builder();
        if (rankables.isEmpty()) {
            return ServiceOutcomeImpl.ok(rankChangesOutcome.build());
        }
        Rankable head = rankables.get(0);
        ServiceOutcome<RankChange> rankChange = this.doRankBefore(user, rankField, head, rankBefore, rankables.size() - 1);
        if (!rankChange.isValid()) {
            rankChangesOutcome.addError(head, this.errorCollectionTransformer.toJiraErrorCollection(rankChange.getErrors(), user));
            return ServiceOutcomeImpl.ok(rankChangesOutcome.build());
        }
        rankChangesOutcome.addSuccessfulChange(rankChange.getValue());
        Rankable rankAfter = head;
        List<Rankable> remaining = rankables.subList(1, rankables.size());
        for (int i = 0; i < remaining.size(); ++i) {
            int remainingRankOperations;
            Rankable rankable = remaining.get(i);
            rankChange = this.doRankAfter(user, rankField, rankable, rankAfter, remainingRankOperations = remaining.size() - i - 1);
            if (!rankChange.isValid()) {
                rankChangesOutcome.addError(rankable, this.errorCollectionTransformer.toJiraErrorCollection(rankChange.getErrors(), user));
                break;
            }
            rankChangesOutcome.addSuccessfulChange(rankChange.getValue());
            rankAfter = rankable;
        }
        return ServiceOutcomeImpl.ok(rankChangesOutcome.build());
    }

    @Nonnull
    private ServiceOutcome<RankChange> doRankAfter(ApplicationUser user, CustomField rankField, Rankable rankable, Rankable rankAfter, int remainingRankOperations) {
        LexoRankOperationOutcome<LexoRankChange> rankOutcome = this.lexoRankManager.rankAfter(rankField.getIdAsLong(), rankable.getId(), rankAfter.getId(), remainingRankOperations);
        return this.updateIssueHistoryAndReindexAffectedIssues(user, rankOutcome);
    }

    private ServiceOutcome<RankChangesOutcome> doRankAfter(ApplicationUser user, CustomField rankField, List<Rankable> rankables, Rankable rankAfter) {
        RankChangesOutcomeImpl.Builder rankChangesOutcomeBuilder = RankChangesOutcomeImpl.builder();
        for (int i = 0; i < rankables.size(); ++i) {
            int remainingRankOperations;
            Rankable toRank = rankables.get(i);
            ServiceOutcome<RankChange> outcome = this.doRankAfter(user, rankField, toRank, rankAfter, remainingRankOperations = rankables.size() - i - 1);
            if (!outcome.isValid()) {
                rankChangesOutcomeBuilder.addError(toRank, this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors(), user));
                break;
            }
            rankChangesOutcomeBuilder.addSuccessfulChange(outcome.getValue());
            rankAfter = toRank;
        }
        return ServiceOutcomeImpl.ok(rankChangesOutcomeBuilder.build());
    }

    @Nonnull
    private ServiceOutcome<RankChange> doRankFirst(ApplicationUser user, CustomField rankField, Rankable rankable) {
        LexoRankOperationOutcome<LexoRankChange> rankOutcome = this.lexoRankManager.rankFirst(rankField.getIdAsLong(), rankable.getId());
        return this.updateIssueHistoryAndReindexAffectedIssues(user, rankOutcome);
    }

    @Nonnull
    private ServiceOutcome<RankChange> doRankLast(ApplicationUser user, CustomField rankField, Rankable rankable) {
        LexoRankOperationOutcome<LexoRankChange> rankOutcome = this.lexoRankManager.rankLast(rankField.getIdAsLong(), rankable.getId());
        return this.updateIssueHistoryAndReindexAffectedIssues(user, rankOutcome);
    }

    @Override
    @Nonnull
    public ServiceOutcome<LexoRank> getRankablePosition(long customFieldId, Rankable rankable) {
        ServiceOutcome<CustomField> rankField = this.getRankField(customFieldId);
        if (!rankField.isValid()) {
            this.log.error("Invalid customFieldId %d passed to RankService.getRankablePosition", customFieldId);
            return ServiceOutcomeImpl.error(rankField);
        }
        Option<LexoRank> rankOption = this.lexoRankManager.getRank(customFieldId, rankable.getId());
        if (rankOption.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Rank for field [%d] and issue [%d] was not found", customFieldId, rankable.getId());
        }
        return ServiceOutcomeImpl.ok(rankOption.get());
    }

    @Override
    public ServiceOutcome<Comparator<Rankable>> createFlatComparator(ApplicationUser user, long customFieldId) {
        ServiceOutcome<CustomField> rankField = this.getRankField(customFieldId);
        if (!rankField.isValid()) {
            this.log.error("Invalid customFieldId %d passed to RankService.createFlatComparator", customFieldId);
            return ServiceOutcomeImpl.error(rankField);
        }
        FlatLexoRankableComparator flatComparator = new FlatLexoRankableComparator(this.lexoRankManager, rankField.getValue());
        return ServiceOutcomeImpl.ok(flatComparator);
    }

    @Override
    public ServiceOutcome<Void> canRank(ApplicationUser user, Rankable rankable) {
        return this.validateRankPermission(user, rankable);
    }

    private ServiceOutcome<CustomField> getRankField(long customFieldId) {
        CustomField customField = this.customFieldService.getCustomField(customFieldId);
        if (customField == null || !this.rankCustomFieldService.isRankCustomFieldType(customField)) {
            return ServiceOutcomeImpl.error("customFieldId", ErrorCollection.Reason.NOT_FOUND, "gh.api.rank.error.custom.field.not.found", customFieldId);
        }
        return ServiceOutcomeImpl.ok(customField);
    }

    private ServiceOutcome<CustomField> getRankFieldAndCheckPermission(ApplicationUser user, long customFieldId, Rankable rankable) {
        return this.getRankFieldAndCheckPermission(user, customFieldId, (List<Rankable>)ImmutableList.of((Object)rankable));
    }

    private ServiceOutcome<CustomField> getRankFieldAndCheckPermission(ApplicationUser user, long customFieldId, List<Rankable> rankables) {
        ServiceOutcome<CustomField> rankField = this.getRankFieldCheckConfiguration(user, customFieldId);
        if (rankField.isInvalid()) {
            return ServiceOutcomeImpl.error(rankField);
        }
        ServiceOutcome<Void> permission = this.validateRankPermissions(user, rankables);
        if (permission.isInvalid()) {
            return ServiceOutcomeImpl.error(permission);
        }
        return rankField;
    }

    private ServiceOutcome<CustomField> getRankFieldCheckConfiguration(ApplicationUser user, long customFieldId) {
        ServiceOutcome<CustomField> customField = this.getRankField(customFieldId);
        if (!customField.isValid()) {
            return customField;
        }
        ServiceOutcome<Void> outcome = this.rankCustomFieldService.validateRankFieldConfiguration(user, customField.getValue());
        if (!outcome.isValid()) {
            ErrorCollection errorCollection = new ErrorCollection();
            for (ErrorCollection.ErrorItem item : outcome.getErrors().getErrors()) {
                errorCollection.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "customFieldId", item.getMessageKey(), item.getParams());
            }
            return ServiceOutcomeImpl.from(errorCollection);
        }
        return customField;
    }

    private ServiceOutcome<Void> validateRankPermission(ApplicationUser user, Rankable rankable) {
        RankableImpl rankableImpl = (RankableImpl)rankable;
        if (rankableImpl.isIssue()) {
            Issue issue = rankableImpl.getIssue();
            if (issue == null) {
                IssueService.IssueResult issueResult = this.issueService.getIssue(user, Long.valueOf(rankableImpl.getId()));
                if (!issueResult.isValid()) {
                    return ServiceOutcomeImpl.from(issueResult.getErrorCollection());
                }
                issue = issueResult.getIssue();
                rankableImpl.setIssue(issue);
            }
            if (!this.permissionService.hasPermission(user, issue, 28)) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.rank.global.permission.error", issue.getKey(), issue.getId());
            }
            return ServiceOutcomeImpl.ok();
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<Void> validateRankPermissions(ApplicationUser user, List<Rankable> rankables) {
        ErrorCollection errors = new ErrorCollection();
        for (Rankable rankable : rankables) {
            ServiceOutcome<Void> outcome = this.validateRankPermission(user, rankable);
            if (outcome.isValid()) continue;
            errors.addAllErrors(outcome.getErrors());
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<RankChange> updateIssueHistoryAndReindexAffectedIssues(ApplicationUser user, LexoRankOperationOutcome<LexoRankChange> rankChangeOutcome) {
        if (rankChangeOutcome.isValid()) {
            LexoRankChange rankChange = rankChangeOutcome.getResult();
            this.reindexAffectedIssues(rankChangeOutcome);
            this.rankCustomFieldService.addChangeItem(user, rankChange);
            return ServiceOutcomeImpl.ok(rankChange);
        }
        return ServiceOutcomeImpl.from(rankChangeOutcome.getErrors());
    }

    private void reindexAffectedIssues(LexoRankOperationOutcome<LexoRankChange> rankChangeOutcome) {
        long updatedIssueId = rankChangeOutcome.getResult().getIssueId();
        Sets.SetView otherAffectedIssues = Sets.difference(rankChangeOutcome.getIssueIdsToReIndex(), (Set)ImmutableSet.of((Object)updatedIssueId));
        this.issueIndexService.reindexIssuesAndSubtasks((Collection<Long>)otherAffectedIssues);
    }
}

