/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

class RankOperationPreparationResult {
    private final List<Long> rankableIds;
    private final Set<Long> issuesNotAvailable;
    private final Set<Issue> forbiddenIssues;

    RankOperationPreparationResult(List<Long> rankableIds, Set<Long> issuesNotAvailable, Set<Issue> forbiddenIssues) {
        this.rankableIds = rankableIds;
        this.issuesNotAvailable = issuesNotAvailable;
        this.forbiddenIssues = forbiddenIssues;
    }

    public List<Long> getRankableIds() {
        return this.rankableIds;
    }

    public Set<Long> getIssuesNotAvailable() {
        return this.issuesNotAvailable;
    }

    public Set<Issue> getForbiddenIssues() {
        return this.forbiddenIssues;
    }

    static class Builder {
        private final List<Long> rankableIds = Lists.newArrayList();
        private final Set<Long> issuesNotAvailable = Sets.newHashSet();
        private final Set<Issue> forbiddenIssues = Sets.newHashSet();

        Builder() {
        }

        Builder addRankableId(long id) {
            this.rankableIds.add(id);
            return this;
        }

        Builder addForbiddenRankIssue(Issue issue) {
            this.forbiddenIssues.add(issue);
            return this;
        }

        Builder addIssueNotAvailable(long id) {
            this.issuesNotAvailable.add(id);
            return this;
        }

        RankOperationPreparationResult build() {
            return new RankOperationPreparationResult(this.rankableIds, this.issuesNotAvailable, this.forbiddenIssues);
        }
    }
}

