/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.rank.RankException;
import com.atlassian.greenhopper.service.rank.RankIndexService;
import com.atlassian.greenhopper.service.rank.RankableImpl;
import com.atlassian.jira.issue.fields.CustomField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankManager {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final int EQUAL = 0;
    private static final int FIRST_SMALLER = -1;
    private static final int SECOND_SMALLER = 1;
    @Autowired
    private RankIndexService rankIndexService;

    public int compareRankablePosition(CustomField rankField, Rankable first, Rankable second) {
        long secondId;
        if (first == null && second == null) {
            return 0;
        }
        if (first == null) {
            return 1;
        }
        if (second == null) {
            return -1;
        }
        long firstId = this.getRankIndexId(first);
        if (firstId == (secondId = this.getRankIndexId(second))) {
            return 0;
        }
        return this.rankIndexService.compare(rankField.getIdAsLong(), firstId, secondId);
    }

    private void handleRankException(RankException e, ErrorCollection errors) {
        errors.addError(ErrorCollection.Reason.SERVER_ERROR, "gh.error.greenhopper.ranking.unavailable", new Object[0]);
        this.log.exception(e);
    }

    private long getRankIndexId(Rankable rankable) {
        return ((RankableImpl)rankable).getRankIndexId();
    }
}

