/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rank.RankDao;
import com.atlassian.greenhopper.service.rank.Rank;
import com.atlassian.greenhopper.service.rank.RankException;
import com.atlassian.greenhopper.service.rank.RankIndex;
import com.atlassian.greenhopper.service.rank.RankIndexBuilder;
import com.atlassian.greenhopper.service.rank.RankIndexService;
import com.atlassian.jira.event.ClearCacheEvent;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankIndexServiceImpl
implements RankIndexService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private RankDao rankDao;
    private Map<Long, Supplier<RankIndex>> rankIndices = new ConcurrentHashMap<Long, Supplier<RankIndex>>();

    @Override
    public int compare(long customFieldId, long firstId, long secondId) {
        Rank second;
        Rank first = this.fetchCreate(customFieldId, firstId);
        if (first.isAfter(second = this.fetchCreate(customFieldId, secondId))) {
            return 1;
        }
        if (first.isBefore(second)) {
            return -1;
        }
        return 0;
    }

    @Override
    public long getIssuePosition(long customFieldId, long issueId) {
        Rank rank = this.fetchCreate(customFieldId, issueId);
        return rank.position;
    }

    public void selfDestruct() {
        this.rankIndices = null;
        this.rankDao = null;
    }

    @Override
    @EventListener
    public void clearIndices(ClearCacheEvent event) {
        this.rankIndices = new HashMap<Long, Supplier<RankIndex>>();
    }

    private Rank fetchCreate(Long customFieldId, Long issueId) {
        Rank rank = this.getIndex(customFieldId).getRank(issueId);
        if (rank == null) {
            rank = new Rank(issueId, Long.MAX_VALUE);
        }
        return rank;
    }

    private synchronized RankIndex getIndex(Long customFieldId) {
        if (this.rankIndices == null) {
            throw new IllegalStateException("A ranking operation was called on an index in a dead classloader. This can be caused by a memory leak following an unclean plugin restart. To avoid data corruption, this operation has been canceled. Please restart JIRA.");
        }
        Supplier supplier = this.rankIndices.get(customFieldId);
        if (supplier == null) {
            supplier = Suppliers.memoize((Supplier)new RankIndexSupplier(customFieldId));
            this.rankIndices.put(customFieldId, (Supplier<RankIndex>)supplier);
        }
        return (RankIndex)supplier.get();
    }

    private class RankIndexSupplier
    implements Supplier<RankIndex> {
        private final Long customFieldId;

        public RankIndexSupplier(Long customFieldId) {
            this.customFieldId = customFieldId;
        }

        public RankIndex get() {
            if (RankIndexServiceImpl.this.rankDao == null) {
                throw new RankException("Rank index was requested before the plugin was initialised");
            }
            long s = System.currentTimeMillis();
            RankIndexServiceImpl.this.log.debug("Initialising rank index for rank field %d", this.customFieldId);
            RankIndexBuilder indexBuilder = new RankIndexBuilder();
            RankIndexServiceImpl.this.rankDao.loadAll(this.customFieldId, indexBuilder);
            RankIndex index = indexBuilder.build();
            RankIndexServiceImpl.this.log.debug("rank index for rank field %d initialised, took %d ms", this.customFieldId, System.currentTimeMillis() - s);
            return index;
        }
    }
}

