/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.service.rank.Rank;
import com.atlassian.greenhopper.service.rank.RankException;
import com.atlassian.greenhopper.service.rank.RankIndex;
import com.atlassian.jira.util.Consumer;
import java.util.ArrayList;
import java.util.List;

public class RankIndexBuilder
implements Consumer<IssueRankingAO> {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private RankIndex index = new RankIndex();
    private boolean hasTailInDb = false;

    public void consume(IssueRankingAO issueLink) {
        Long nextId;
        Long issueId = issueLink.getIssueId();
        Rank rank = this.index.getRank(issueId);
        if (rank == null) {
            rank = new Rank(issueId);
            this.index.putRank(rank);
        }
        if ((nextId = issueLink.getNextId()) != null) {
            Rank nextRank = this.index.getRank(nextId);
            if (nextRank == null) {
                nextRank = new Rank(nextId);
                this.index.putRank(nextRank);
            }
            rank.next = nextRank;
            nextRank.previous = rank;
        } else {
            this.hasTailInDb = true;
        }
    }

    public RankIndex build() {
        if (this.index.getRanks().isEmpty()) {
            return this.index;
        }
        ArrayList<Rank> noPrevious = new ArrayList<Rank>();
        ArrayList<Rank> noNext = new ArrayList<Rank>();
        for (Rank rank : this.index.getRanks().values()) {
            if (rank.previous == null) {
                noPrevious.add(rank);
            }
            if (rank.next != null) continue;
            noNext.add(rank);
        }
        this.validate(noPrevious, noNext);
        this.connectFirstAndLast(this.index, (Rank)noPrevious.get(0), (Rank)noNext.get(0));
        this.validateStructure();
        this.index.reindex();
        this.log.info("Initialization finished. Number of ranked issues: %d", this.index.getRanks().size());
        return this.index;
    }

    private void connectFirstAndLast(RankIndex index, Rank first, Rank last) {
        Rank head = index.head;
        head.next = first;
        first.previous = head;
        Rank tail = index.tail;
        tail.previous = last;
        last.next = tail;
    }

    private void validateStructure() {
        Rank rank = this.index.head;
        int c = 0;
        int size = this.index.getSize() + 2;
        while (rank != null) {
            rank = rank.next;
            if (++c <= size) continue;
            throw new RankException("Inconsistent structure in Rank table! Chain length is larger than number of elements in list.");
        }
        if (c < size) {
            throw new RankException("Inconsistent structure in Rank table! Linked list is not linear, chain length is smaller than number of elements in list.");
        }
    }

    private void validate(List<Rank> noPrevious, List<Rank> noNext) {
        if (!this.hasTailInDb) {
            throw new RankException("The tail end of the GreenHopper Global Rank is missing. Please update the rank table and ensure that there is exactly one issue that has no child and exactly one that has no parent.");
        }
        if (noPrevious.isEmpty()) {
            throw new RankException("Head entry is missing in rank table! Please update the rank table and ensure that there is exactly one issue that has no parent.");
        }
        if (noNext.isEmpty()) {
            throw new RankException("Tail entry is missing in rank table! Please update the rank table and ensure that there is exactly one issue that has no child.");
        }
        if (noPrevious.size() > 1) {
            throw new RankException("Multiple heads found in rank chain: issueIDs " + noPrevious + " have no parent link. Please update the rank table and ensure that there is exactly one issue that has no child and exactly one that has no parent.");
        }
        if (noNext.size() > 1) {
            throw new RankException("Multiple tails found in rank chain: issueIDs " + noNext + " have no child link. Please update the rank table and ensure that there is exactly one issue that has no child and exactly one that has no parent.");
        }
    }
}

