/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.service.rank.Rank;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RankIndex {
    Rank head = new Rank(null, -1L);
    Rank tail;
    private Map<Long, Rank> ranks;

    public RankIndex() {
        this.head.next = this.tail = new Rank(null, Long.MAX_VALUE);
        this.tail.previous = this.head;
        this.ranks = new HashMap<Long, Rank>();
    }

    public Rank getRank(Long issueId) {
        return this.ranks.get(issueId);
    }

    public void putRank(Rank rank) {
        this.ranks.put(rank.id, rank);
    }

    public boolean isRanked(Long issueId) {
        return this.ranks.containsKey(issueId);
    }

    public void reindex() {
        Rank data = this.head.next;
        long position = 1L;
        while (!data.equals(this.tail)) {
            ++position;
            data.position = data.position;
            data = data.next;
        }
    }

    public int getSize() {
        return this.ranks.size();
    }

    public Map<Long, Rank> getRanks() {
        return this.ranks;
    }

    public Iterable<Long> getIssueIterable() {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return RankIndex.this.getIssueIterator();
            }
        };
    }

    public Iterator<Long> getIssueIterator() {
        return new RankIterator(this.head);
    }

    private static class RankIterator
    implements Iterator<Long> {
        private Rank currentRank;

        private RankIterator(Rank head) {
            this.currentRank = head;
        }

        @Override
        public boolean hasNext() {
            return this.currentRank != null;
        }

        @Override
        public Long next() {
            Long issue = this.currentRank.id;
            this.currentRank = this.currentRank.next;
            return issue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

