/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.rank.RankCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.ManagedCustomFieldProvider;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.service.rank.RankCustomFieldService;
import com.atlassian.greenhopper.service.rank.SortedByRankFieldResult;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankCustomFieldServiceImpl
implements RankCustomFieldService,
ManagedCustomFieldProvider {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String VALUES_SEPARATOR = ", ";
    private static final String NO_KEY_VALUE = "none";
    private static final String KEY_DEFAULT_RANK_CUSTOMFIELD_ID = "GreenHopper.Rank.Default.customfield.id";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private IssueUpdater issueUpdater;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    private FieldManager fieldManager;

    private CustomField createDefaultRankField() {
        CustomField field = this.customFieldService.createCustomField(RankCFType.CUSTOMFIELD_METADATA);
        this.propertyDao.setLongProperty(KEY_DEFAULT_RANK_CUSTOMFIELD_ID, field.getIdAsLong());
        return field;
    }

    @Override
    public synchronized Option<CustomField> getDefaultRankField() {
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_RANK_CUSTOMFIELD_ID);
        if (id != null) {
            CustomField rankField = this.customFieldService.getCustomField(id);
            if (rankField != null) {
                return Option.some((Object)rankField);
            }
            if (this.customFieldService.verifyCustomFieldExistsInDB(id)) {
                throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", "Rank", id));
            }
        }
        return Option.none();
    }

    @Override
    public synchronized CustomField getOrCreateDefaultRankField() {
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_RANK_CUSTOMFIELD_ID);
        if (id != null) {
            CustomField rankField = this.customFieldService.getCustomField(id);
            if (rankField != null) {
                return rankField;
            }
            if (this.customFieldService.verifyCustomFieldExistsInDB(id)) {
                throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", "Rank", id));
            }
        }
        return this.createDefaultRankField();
    }

    @Override
    public boolean isRankField(long customFieldId) {
        CustomField customField = this.customFieldService.getCustomField(customFieldId);
        if (customField == null) {
            return false;
        }
        return this.isRankField(customField);
    }

    @Override
    public boolean isRankField(CustomField customField) {
        if (!this.isRankCustomFieldType(customField)) {
            return false;
        }
        if (customField.isGlobal()) {
            return true;
        }
        this.log.error("The GreenHopper rank custom field with id %s and name %s is not global. This field must be global, thus associated with all issue types and use the global context, in order to correctly work.", customField.getId(), customField.getName());
        return false;
    }

    @Override
    public boolean isRankCustomFieldType(CustomField customField) {
        return customField != null && customField.getCustomFieldType() instanceof RankCFType;
    }

    @Override
    public ServiceOutcome<Void> validateRankFieldConfiguration(CustomField customField) {
        if (customField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "CustomField must not be null", new Object[0]);
        }
        if (!(customField.getCustomFieldType() instanceof RankCFType)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "The custom field with name {0} and id {1} is not of type Global Rank", customField.getName(), customField.getId());
        }
        if (!customField.isGlobal()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.not.global", customField.getName(), customField.getId());
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public ServiceOutcome<SortedByRankFieldResult> getSortedByRankField(Query query) {
        OrderBy orderByClause = query.getOrderByClause();
        if (orderByClause == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        List searchSorts = orderByClause.getSearchSorts();
        if (searchSorts.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        SearchSort searchSort = (SearchSort)searchSorts.get(0);
        String sortField = searchSort.getField();
        return this.getRankFieldBySearchSort(searchSort);
    }

    @Override
    public ServiceOutcome<Boolean> isFieldNameInQuerySafe(CustomField rankField) {
        if (rankField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "CustomField must not be null", new Object[0]);
        }
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(rankField.getName());
        if (customFields.size() == 0) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "CustomField not found when looked up by name!", new Object[0]);
        }
        if (customFields.size() > 1) {
            return ServiceOutcomeImpl.ok(false);
        }
        return ServiceOutcomeImpl.ok(true);
    }

    private ServiceOutcome<SortedByRankFieldResult> getRankFieldBySearchSort(SearchSort searchSort) {
        String fieldName = searchSort.getField();
        ServiceOutcome<SortedByRankFieldResult> result = this.getRankFieldByJqlFieldName(fieldName);
        if (!result.isValid()) {
            return result;
        }
        if (!result.getValue().isValid()) {
            return result;
        }
        SortOrder sortOrder = searchSort.getSortOrder();
        if (sortOrder == null || sortOrder.equals((Object)SortOrder.ASC)) {
            return result;
        }
        ErrorCollection warnings = new ErrorCollection();
        warnings.addError("gh.rank.global.jqlorderby.sort.order.descending", new Object[0]);
        return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(result.getValue().getCustomField(), warnings, true));
    }

    @Override
    @Nonnull
    public List<CustomField> getRankFields() {
        return this.customFieldService.getCustomFields(RankCFType.class);
    }

    private ServiceOutcome<SortedByRankFieldResult> getRankFieldByJqlFieldName(String fieldName) {
        JqlCustomFieldId id = JqlCustomFieldId.parseJqlCustomFieldId((String)fieldName);
        if (id != null) {
            CustomField customField = this.customFieldService.getCustomField(id.getId());
            if (customField != null && this.isRankCustomFieldType(customField)) {
                return ServiceOutcomeImpl.ok(SortedByRankFieldResult.valid(customField));
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(fieldName);
        if (customFields == null || customFields.size() == 0) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        if (customFields.size() == 1) {
            CustomField customField = (CustomField)customFields.iterator().next();
            if (this.isRankCustomFieldType(customField)) {
                if (this.customFieldService.isSystemFieldName(fieldName)) {
                    this.log.error("The rank custom field with name %s and id %s shares a name with a system field. In order to use a rank custom field its name must be unique.", customField.getName(), customField.getId());
                    ErrorCollection warnings = new ErrorCollection();
                    warnings.addError("gh.rank.global.jqlorderby.systemfield.name.collision", customField.getName(), customField.getId());
                    return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(customField, warnings, false));
                }
                return ServiceOutcomeImpl.ok(SortedByRankFieldResult.valid(customField));
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        for (CustomField customField : customFields) {
            if (!this.isRankCustomFieldType(customField)) continue;
            this.log.error("The rank custom field with name %s and id %s shares a name with one or more other custom fields. In order to use a rank custom field its name must be unique.", customField.getName(), customField.getId());
            ErrorCollection warnings = new ErrorCollection();
            warnings.addError("gh.rank.global.jqlorderby.customfield.name.collision", customField.getName(), customField.getId());
            return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(customField, warnings, true));
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
    }

    private String getPositionMessage(I18n2 i18n, Long oldPosition, Long newPosition) {
        if (oldPosition > newPosition) {
            return i18n.getText("gh.rank.global.history.higher");
        }
        if (oldPosition < newPosition) {
            return i18n.getText("gh.rank.global.history.lower");
        }
        return "";
    }

    @Override
    public Collection<CustomField> getManagedFields() {
        Option<CustomField> defaultRankField = this.getDefaultRankField();
        if (defaultRankField.isDefined()) {
            return Arrays.asList((CustomField)defaultRankField.get());
        }
        return Collections.emptyList();
    }
}

