/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.RankOperationPreparationResult;
import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

class RankChangesResult
implements BatchRankChange {
    private final List<RankChange> successfulRankChanges;
    private final Map<Long, ErrorCollection> errorCollections;

    private RankChangesResult(List<RankChange> successfulRankChanges, Map<Long, ErrorCollection> errorCollections) {
        this.successfulRankChanges = successfulRankChanges;
        this.errorCollections = errorCollections;
    }

    @Override
    public List<RankChange> getSuccessfulRankChanges() {
        return this.successfulRankChanges;
    }

    @Override
    public Map<Long, ErrorCollection> getErrorCollections() {
        return this.errorCollections;
    }

    static Builder builder(RankOperationPreparationResult preparation) {
        return new Builder(preparation);
    }

    static class Builder {
        private static final String NO_ISSUE_MSG = "gh.search.noissues";
        private static final String NO_PERMISSION_MSG = "gh.rank.global.permission.error";
        private final List<RankChange> successfulRankChanges = Lists.newArrayList();
        private final Map<Long, ErrorCollection> errorCollections = Maps.newHashMap();

        private Builder(RankOperationPreparationResult preparation) {
            for (long id : preparation.getIssuesNotAvailable()) {
                this.errorCollections.put(id, new ErrorCollection().addError(ErrorCollection.Reason.VALIDATION_FAILED, NO_ISSUE_MSG, new Object[0]));
            }
            for (Issue issue : preparation.getForbiddenIssues()) {
                this.errorCollections.put(issue.getId(), new ErrorCollection().addError(ErrorCollection.Reason.FORBIDDEN, NO_PERMISSION_MSG, issue.getKey(), issue.getId()));
            }
        }

        Builder addSuccessfulChange(RankChange rankChange) {
            this.successfulRankChanges.add(rankChange);
            return this;
        }

        Builder addError(long rankId, ErrorCollection errorCollection) {
            this.errorCollections.put(rankId, errorCollection);
            return this;
        }

        BatchRankChange build() {
            return new RankChangesResult(this.successfulRankChanges, this.errorCollections);
        }

        Builder addOutcome(ServiceOutcome<RankChange> outcome, long rankId) {
            if (outcome.isValid()) {
                return this.addSuccessfulChange(outcome.get());
            }
            return this.addError(rankId, outcome.getErrors());
        }
    }
}

