/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class RankChangesOutcomeImpl
implements RankChangesOutcome {
    private final List<RankChange> successfulRankChanges;
    private final Map<Rankable, ErrorCollection> errorCollections;

    private RankChangesOutcomeImpl(List<RankChange> successfulRankChanges, Map<Rankable, ErrorCollection> errorCollections) {
        this.successfulRankChanges = successfulRankChanges;
        this.errorCollections = errorCollections;
    }

    @Override
    public List<RankChange> getSuccessfulRankChanges() {
        return this.successfulRankChanges;
    }

    @Override
    public Map<Rankable, ErrorCollection> getErrorCollections() {
        return this.errorCollections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RankChangesOutcome source) {
        Builder builder = new Builder();
        builder.addSuccessfulChanges(source.getSuccessfulRankChanges());
        builder.addErrorCollections(source.getErrorCollections());
        return builder;
    }

    public static RankChangesOutcomeImpl buildNoop() {
        return RankChangesOutcomeImpl.builder().build();
    }

    public static class Builder {
        private final List<RankChange> successfulRankChanges = Lists.newArrayList();
        private final Map<Rankable, ErrorCollection> errorCollections = Maps.newHashMap();

        private Builder() {
        }

        public Builder addSuccessfulChange(RankChange rankChange) {
            this.successfulRankChanges.add(rankChange);
            return this;
        }

        public Builder addError(Rankable rankable, ErrorCollection errorCollection) {
            this.errorCollections.put(rankable, errorCollection);
            return this;
        }

        public RankChangesOutcomeImpl build() {
            return new RankChangesOutcomeImpl(this.successfulRankChanges, this.errorCollections);
        }

        public Builder addSuccessfulChanges(List<RankChange> successfulRankChanges) {
            if (successfulRankChanges != null) {
                this.successfulRankChanges.addAll(successfulRankChanges);
            }
            return this;
        }

        public Builder addErrorCollections(Map<Rankable, ErrorCollection> errorCollections) {
            if (errorCollections != null) {
                this.errorCollections.putAll(errorCollections);
            }
            return this;
        }
    }
}

