/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.JpoPreconditionChecker;
import com.atlassian.greenhopper.service.rank.JpoRankService;
import com.atlassian.greenhopper.service.rank.RecursiveRankOperations;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JpoRankServiceImpl
implements JpoRankService {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private RecursiveRankOperations rankOperations;
    @Autowired
    private JpoPreconditionChecker preconditionChecker;

    @Override
    public ServiceOutcome<BatchRankChange> rankBefore(List<Long> ids, long anchorId, long domain, ApplicationUser user) {
        this.log.debug("rank before request in domain %d with anchor %d:: %s", domain, anchorId, Iterables.toString(ids));
        return this.rankOperations.rankBefore(ids, anchorId, domain, user);
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankAfter(List<Long> ids, long anchorId, long domain, ApplicationUser user) {
        this.log.debug("rank after request in domain %d with anchor %d: %s", domain, anchorId, Iterables.toString(ids));
        return this.rankOperations.rankAfter(ids, anchorId, domain, user);
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankFirst(List<Long> ids, long domain, ApplicationUser user) {
        this.log.debug("rank first request in domain %d %s", domain, Iterables.toString(ids));
        return this.rankOperations.rankFirst(ids, domain, user);
    }

    @Override
    public ServiceOutcome<BatchRankChange> rankLast(List<Long> ids, long domain, ApplicationUser user) {
        this.log.debug("rank last request in domain %d: %s", domain, Iterables.toString(ids));
        return this.rankOperations.rankLast(ids, domain, user);
    }

    @Override
    public ServiceOutcome<Void> deleteIds(Iterable<Long> ids, ApplicationUser user) {
        this.log.debug("delete request for IDs: %s", Iterables.toString(ids));
        ErrorCollection preconditionErrors = this.preconditionChecker.checkDeleteIdsPermission(ids, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        return this.lexoRankManager.deleteRanksForIssues(ids);
    }

    @Override
    public ServiceOutcome<Void> deleteIdsBetween(long fromId, long toId, ApplicationUser user) {
        this.log.debug("delete request for IDs in [%d, %d]", fromId, toId);
        ErrorCollection preconditionErrors = this.preconditionChecker.checkDeleteIdRangePermission(fromId, toId, user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        return this.lexoRankManager.deleteRanksForIssueIdsBetween(fromId, toId);
    }

    @Override
    public ServiceOutcome<List<Long>> sort(Collection<Long> ids, long domain, ApplicationUser user) {
        this.log.debug("sort request in domain %d: %s", domain, Iterables.toString(ids));
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankReadPermission(user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        final Map<Long, LexoRank> rankValues = this.lexoRankManager.getRankValues(domain, ids);
        ArrayList ranked = Lists.newArrayList((Iterable)Iterables.filter(ids, (Predicate)new Predicate<Long>(){

            public boolean apply(Long id) {
                return rankValues.keySet().contains(id);
            }
        }));
        Collections.sort(ranked, new Comparator<Long>(){

            @Override
            public int compare(Long id1, Long id2) {
                return ((LexoRank)rankValues.get(id1)).compareTo((LexoRank)rankValues.get(id2));
            }
        });
        this.log.debug("sorted rank items: %s", Joiner.on((String)",").join((Iterable)ranked));
        return ServiceOutcomeImpl.ok(ranked);
    }

    @Override
    public ServiceOutcome<Map<Long, String>> getLexoRankValues(Collection<Long> ids, long domain, ApplicationUser user) {
        this.log.debug("rank query request in domain %d: %s", domain, Iterables.toString(ids));
        ErrorCollection preconditionErrors = this.preconditionChecker.checkRankReadPermission(user);
        if (preconditionErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(preconditionErrors);
        }
        Map<Long, LexoRank> rankValues = this.lexoRankManager.getRankValues(domain, ids);
        HashMap transformed = Maps.newHashMapWithExpectedSize((int)rankValues.size());
        for (Map.Entry<Long, LexoRank> entry : rankValues.entrySet()) {
            transformed.put(entry.getKey(), entry.getValue().toString());
        }
        return ServiceOutcomeImpl.ok(transformed);
    }
}

