/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.rank.RankOperationPreparationResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.compatibility.bridge.issue.IssueServiceBridge;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class JpoRankOperationPreparer {
    @VisibleForTesting
    static final int CAN_RANK_PERMISSION = 28;
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private IssueServiceBridge issueServiceBridge;

    JpoRankOperationPreparer() {
    }

    RankOperationPreparationResult prepareRankOperation(List<Long> ids, long domain, ApplicationUser user) {
        this.lexoRankManager.initField(domain);
        RankOperationPreparationResult.Builder builder = new RankOperationPreparationResult.Builder();
        Iterator iterator = Iterables.filter(ids, (Predicate)Predicates.notNull()).iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (!this.isVirtualIssue(id)) {
                Optional<MutableIssue> issue = this.getIssue(id, user);
                if (!issue.isPresent()) {
                    builder.addIssueNotAvailable(id);
                    continue;
                }
                if (!this.permissionService.hasPermission(user, (Issue)issue.get(), 28)) {
                    builder.addForbiddenRankIssue((Issue)issue.get());
                    continue;
                }
                if (this.isVirtualDomain(domain)) {
                    this.lexoRankManager.getRankOrRankInitially(domain, id, false);
                }
                builder.addRankableId(id);
                continue;
            }
            this.lexoRankManager.getRankOrRankInitially(domain, id, false);
            builder.addRankableId(id);
        }
        return builder.build();
    }

    private boolean isVirtualIssue(long id) {
        return id < 0L;
    }

    private boolean isVirtualDomain(long domain) {
        return domain < 0L;
    }

    private Optional<MutableIssue> getIssue(long id, ApplicationUser user) {
        IssueService.IssueResult issueResult = this.issueServiceBridge.getIssue(user, id);
        if (issueResult.isValid()) {
            return Optional.of((Object)issueResult.getIssue());
        }
        return Optional.absent();
    }
}

