/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancingService;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class JpoPreconditionChecker {
    @Autowired
    private LexoRankBalancingService lexoRankBalancingService;

    JpoPreconditionChecker() {
    }

    ErrorCollection checkRankOperationPreconditions(long domain, ApplicationUser user) {
        return this.mergeErrorCollections(this.checkLoggedIn(user), this.checkRankingEnabled(domain));
    }

    ErrorCollection checkRankReadPermission(ApplicationUser user) {
        return this.checkLoggedIn(user);
    }

    ErrorCollection checkDeleteIdsPermission(Iterable<Long> ids, ApplicationUser user) {
        return this.mergeErrorCollections(this.checkLoggedIn(user), this.checkPositiveIds(ids));
    }

    ErrorCollection checkDeleteIdRangePermission(long from, long to, ApplicationUser user) {
        return this.mergeErrorCollections(this.checkLoggedIn(user), this.checkPositiveFromToIds(from, to));
    }

    private ErrorCollection mergeErrorCollections(ErrorCollection ... preconditions) {
        ErrorCollection allErrors = new ErrorCollection();
        for (int i = 0; i < preconditions.length; ++i) {
            if (!preconditions[i].hasErrors()) continue;
            allErrors.addAllErrors(preconditions[i]);
        }
        return allErrors;
    }

    private ErrorCollection checkLoggedIn(ApplicationUser user) {
        ErrorCollection errors = new ErrorCollection();
        if (user == null) {
            errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, "User must not be null", new Object[0]);
        }
        return errors;
    }

    private ErrorCollection checkPositiveIds(Iterable<Long> ids) {
        ErrorCollection errorCollection = new ErrorCollection();
        for (Long id : ids) {
            if (id < 0L) continue;
            errorCollection.addError(ErrorCollection.Reason.VALIDATION_FAILED, String.format("Cannot perform operation on positive rankItem ID: %d", id), new Object[0]);
        }
        return errorCollection;
    }

    private ErrorCollection checkPositiveFromToIds(long fromId, long toId) {
        ErrorCollection errors = new ErrorCollection();
        if (fromId >= 0L || toId >= 0L) {
            errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, "fromId (%d) and toId (%d) must be negative", fromId, toId);
        }
        return errors;
    }

    private ErrorCollection checkRankingEnabled(long domain) {
        ErrorCollection errors = new ErrorCollection();
        if (this.isRankingDisabled(domain)) {
            errors.addError(ErrorCollection.Reason.SERVER_ERROR, "Ranking operations are disabled. Please try again later", new Object[0]);
        }
        return errors;
    }

    private boolean isRankingDisabled(long domain) {
        return this.lexoRankBalancingService.rankingOperationsDisabled(domain);
    }
}

