/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rank;

import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.jira.issue.fields.CustomField;
import io.atlassian.fugue.Option;
import java.util.Comparator;

public class FlatLexoRankableComparator
implements Comparator<Rankable> {
    public static final int EQUAL = 0;
    public static final int FIRST_SMALLER = -1;
    public static final int SECOND_SMALLER = 1;
    private final LexoRankManager lexoRankManager;
    private final CustomField customField;

    public FlatLexoRankableComparator(LexoRankManager lexoRankManager, CustomField customField) {
        this.lexoRankManager = lexoRankManager;
        this.customField = customField;
    }

    @Override
    public int compare(Rankable first, Rankable second) {
        if (first == null && second == null) {
            return 0;
        }
        if (first == null) {
            return 1;
        }
        if (second == null) {
            return -1;
        }
        Option<LexoRank> firstRankOption = this.lexoRankManager.getRank(this.customField.getIdAsLong(), first.getId());
        Option<LexoRank> secondRankOption = this.lexoRankManager.getRank(this.customField.getIdAsLong(), second.getId());
        if (firstRankOption.isEmpty() && secondRankOption.isEmpty()) {
            return 0;
        }
        if (firstRankOption.isEmpty()) {
            return 1;
        }
        if (secondRankOption.isEmpty()) {
            return -1;
        }
        LexoRank firstRank = (LexoRank)firstRankOption.get();
        LexoRank secondRank = (LexoRank)secondRankOption.get();
        return firstRank.compareTo(secondRank);
    }
}

