/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.query;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.util.jql.project.ProjectContextVisitor;
import com.atlassian.greenhopper.util.jql.project.ProjectContextVisitorProvider;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class QueryToProjectMapper
implements GreenHopperCache {
    private LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    private final ProjectContextVisitorProvider projectContextVisitorProvider;
    private final SearchService jiraSearchService;
    private final ProjectService projectService;
    private final Cache<Query, Set<Long>> guessedProjectsCache;

    @Inject
    public QueryToProjectMapper(ProjectContextVisitorProvider projectContextVisitorProvider, SearchService jiraSearchService, CacheFactoryManager cacheFactoryManager, ProjectService projectService) {
        this.projectContextVisitorProvider = projectContextVisitorProvider;
        this.jiraSearchService = jiraSearchService;
        this.projectService = projectService;
        this.guessedProjectsCache = cacheFactoryManager.create().getCache(QueryToProjectMapper.class.getCanonicalName() + ".boardIdToProjectsCache", null, new CacheSettingsBuilder().local().flushable().expireAfterWrite(30L, TimeUnit.MINUTES).build());
    }

    public Set<Project> getProjectsForQuery(ApplicationUser user, Query query, boolean explicit) {
        Set<Long> projectIds = this.getProjectIdsForQuery(user, query, explicit);
        return this.mapToProjects(user, projectIds);
    }

    public Set<Long> getProjectIdsForQuery(ApplicationUser user, Query query, boolean explicit) {
        if (explicit) {
            return this.getExplicitProjectIdsForQueryOverrideSecurity(user, query);
        }
        QueryContext queryContext = this.jiraSearchService.getQueryContext(user, query);
        return this.getProjectIdsFromContext(query, queryContext);
    }

    private Set<Long> getExplicitProjectIdsForQueryOverrideSecurity(ApplicationUser user, Query query) {
        if (query == null) {
            return Collections.emptySet();
        }
        Set<Long> projectIdsFromCache = this.guessedProjectsCache.get(query);
        if (projectIdsFromCache != null) {
            return projectIdsFromCache;
        }
        Clause whereClause = query.getWhereClause();
        if (whereClause == null) {
            return Collections.emptySet();
        }
        ProjectContextVisitor projectContextVisitor = this.projectContextVisitorProvider.getProjectContextVisitor(user);
        whereClause.accept((ClauseVisitor)projectContextVisitor);
        Set<Long> projectIds = projectContextVisitor.getProjectIds();
        if (projectContextVisitor.isResultUserContextIndependent()) {
            this.guessedProjectsCache.put(query, projectIds);
        }
        return projectIds;
    }

    private Set<Long> getProjectIdsFromContext(Query query, QueryContext queryContext) {
        Collection projectIssueTypeContexts = queryContext.getProjectIssueTypeContexts();
        this.logger.debug("Query Context for query '%s' - %s", query, queryContext);
        boolean globalContext = false;
        HashSet<Long> projectIds = new HashSet<Long>();
        for (QueryContext.ProjectIssueTypeContexts projectIssueTypeContext : projectIssueTypeContexts) {
            ProjectContext projectContext = projectIssueTypeContext.getProjectContext();
            if (projectContext.isAll()) {
                globalContext = true;
                break;
            }
            projectIds.add(projectContext.getProjectId());
        }
        if (globalContext) {
            return Collections.emptySet();
        }
        return projectIds;
    }

    @Override
    public void flushCache() {
        this.guessedProjectsCache.removeAll();
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        this.flushCache();
    }

    private Set<Project> mapToProjects(ApplicationUser user, Collection<Long> projectIds) {
        return projectIds.stream().map(projectId -> this.projectService.getProjectById(user, projectId)).filter(ServiceResult::isValid).map(ProjectService.AbstractProjectResult::get).collect(Collectors.toCollection(() -> new HashSet(projectIds.size())));
    }
}

