/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.query;

import com.atlassian.greenhopper.model.query.ProjectClauseVisitor;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.query.QueryToProjectMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class QueryServiceImpl
implements QueryService {
    private final SearchService jiraSearchService;
    private final ProjectManager projectManager;
    private final SearchRequestManager searchRequestManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final RapidViewPermissionService rapidViewPermissionService;
    private final QueryToProjectMapper queryToProjectMapper;

    @Inject
    public QueryServiceImpl(SearchService jiraSearchService, ProjectManager projectManager, SearchRequestManager searchRequestManager, I18nHelper.BeanFactory i18nBeanFactory, RapidViewPermissionService rapidViewPermissionService, QueryToProjectMapper queryToProjectMapper) {
        this.jiraSearchService = jiraSearchService;
        this.projectManager = projectManager;
        this.searchRequestManager = searchRequestManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.rapidViewPermissionService = rapidViewPermissionService;
        this.queryToProjectMapper = queryToProjectMapper;
    }

    @Override
    public boolean isProjectClauseOnlyQuery(@Nullable Query query) {
        if (query == null || query.getWhereClause() == null) {
            return false;
        }
        ProjectClauseVisitor projectClauseVisitor = new ProjectClauseVisitor();
        query.getWhereClause().accept((ClauseVisitor)projectClauseVisitor);
        return projectClauseVisitor.isValid();
    }

    @Override
    public List<Project> getProjectsInProjectClauseOnlyQuery(ApplicationUser user, @Nonnull Query projectBasedQuery) {
        LinkedHashSet projectIds = new LinkedHashSet();
        QueryContext simpleQueryContext = this.jiraSearchService.getSimpleQueryContext(user, projectBasedQuery);
        Collection projectIssueTypeContexts = simpleQueryContext.getProjectIssueTypeContexts();
        for (QueryContext.ProjectIssueTypeContexts ctx : projectIssueTypeContexts) {
            if (ctx.getProjectContext().isAll() || ctx.getIssueTypeContexts().size() != 1 || !((IssueTypeContext)ctx.getIssueTypeContexts().iterator().next()).isAll()) continue;
            projectIds.addAll(ctx.getProjectIdInList());
        }
        ArrayList<Project> result = new ArrayList<Project>();
        for (Long projectId : projectIds) {
            result.add(this.projectManager.getProjectObj(projectId));
        }
        return result;
    }

    @Override
    public ServiceOutcome<Set<Project>> getProjectsForRapidViewFilterQuery(ApplicationUser user, @Nonnull RapidView rapidView) {
        return this.getProjectsForRapidView(user, rapidView, false);
    }

    @Override
    public ServiceOutcome<Set<Project>> getProjectsForRapidViewFilterQuery(ApplicationUser user, @Nonnull Query filterQuery) {
        Set<Project> projects = this.queryToProjectMapper.getProjectsForQuery(user, filterQuery, false);
        return ServiceOutcomeImpl.ok(projects);
    }

    @Override
    public ServiceOutcome<Set<Project>> getExplicitProjectsForRapidViewFilterQuery(ApplicationUser user, @Nonnull RapidView rapidView) {
        return this.getProjectsForRapidView(user, rapidView, true);
    }

    private ServiceOutcome<Set<Project>> getProjectsForRapidView(ApplicationUser user, RapidView rapidView, boolean explicit) {
        Optional<SearchRequest> searchRequestWithoutSanitization = this.getSearchRequestWithoutSanitization(user, rapidView);
        return searchRequestWithoutSanitization.map(SearchRequest::getQuery).map(query -> this.queryToProjectMapper.getProjectsForQuery(user, (Query)query, explicit)).map(ServiceOutcomeImpl::ok).orElseGet(() -> this.filterNotFound(user));
    }

    @Override
    public ServiceOutcome<Boolean> projectBelongsToRapidView(ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Project project) {
        Optional<SearchRequest> searchRequestWithoutSanitization = this.getSearchRequestWithoutSanitization(user, rapidView);
        return searchRequestWithoutSanitization.map(SearchRequest::getQuery).map(query -> this.queryToProjectMapper.getProjectIdsForQuery(user, (Query)query, true)).map(set -> set.contains(project.getId())).map(ServiceOutcomeImpl::ok).orElseGet(() -> this.filterNotFound(user));
    }

    private Optional<SearchRequest> getSearchRequestWithoutSanitization(ApplicationUser user, RapidView rapidView) {
        boolean canSee = this.rapidViewPermissionService.canSeeRapidView(user, rapidView);
        if (!canSee) {
            return Optional.empty();
        }
        SearchRequest searchRequest = this.searchRequestManager.getSearchRequestById(rapidView.getSavedFilterId());
        return Optional.ofNullable(searchRequest);
    }

    private <T> ServiceOutcome<T> filterNotFound(ApplicationUser user) {
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, this.i18nBeanFactory.getInstance(user).getText("admin.errors.filters.nonexistent"), new Object[0]);
    }
}

