/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.properties;

import com.atlassian.greenhopper.service.properties.UserPropertyService;
import com.atlassian.greenhopper.user.UserIssueTypeManagerBridge;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPropertyServiceImpl
implements UserPropertyService {
    private static final String QUICK_CREATE_FIELDS = "jira.quick.create.fields";
    private static final String USE_QUICK_FORM = "jira.quick.edit.use";
    private static final String FIELD_SEPARATOR = ",";
    @Autowired
    private UserPropertyManager userPropertyManager;
    @Autowired
    private UserIssueTypeManagerBridge userIssueTypeManagerBridge;

    @Override
    public String getQuickCreateIssueTypeId(@NotNull ApplicationUser user) {
        return this.userIssueTypeManagerBridge.getLastUsedIssueTypeId(user);
    }

    @Override
    public void setQuickCreateIssueTypeId(@NotNull ApplicationUser user, String issueTypeId) {
        this.userIssueTypeManagerBridge.setLastUsedIssueTypeId(user, issueTypeId);
    }

    @Override
    public List<String> getQuickCreateFields(@NotNull ApplicationUser user) {
        String userFields = this.getTextProperty(QUICK_CREATE_FIELDS, user);
        return StringUtils.isNotBlank((CharSequence)userFields) ? Collections.unmodifiableList(Arrays.asList(userFields.split(FIELD_SEPARATOR))) : Collections.emptyList();
    }

    @Override
    public void setQuickCreateFields(@NotNull ApplicationUser user, List<String> fields) {
        String fieldString = StringUtils.join((Object[])fields.toArray(), (String)FIELD_SEPARATOR);
        this.setTextProperty(QUICK_CREATE_FIELDS, fieldString, user);
    }

    @Override
    public Boolean getUseQuickFormPreference(@NotNull ApplicationUser user) {
        return this.getBooleanProperty(USE_QUICK_FORM, user);
    }

    @Override
    public void setUseQuickFormPreference(@NotNull ApplicationUser user, boolean useQuickForm) {
        this.setBooleanProperty(USE_QUICK_FORM, useQuickForm, user);
    }

    private boolean getBooleanProperty(String propertyKey, @NotNull ApplicationUser user) {
        PropertySet properties = this.userPropertyManager.getPropertySet(user);
        if (properties.exists(propertyKey)) {
            return properties.getBoolean(propertyKey);
        }
        return false;
    }

    private void setBooleanProperty(String propertyKey, boolean propertyValue, @NotNull ApplicationUser user) {
        PropertySet properties = this.userPropertyManager.getPropertySet(user);
        if (propertyValue || properties.exists(propertyKey)) {
            properties.setBoolean(propertyKey, propertyValue);
        }
    }

    private String getTextProperty(String propertyKey, @NotNull ApplicationUser user) {
        PropertySet properties = this.userPropertyManager.getPropertySet(user);
        if (properties.exists(propertyKey)) {
            return properties.getText(propertyKey);
        }
        return null;
    }

    private void setTextProperty(String propertyKey, String propertyValue, @NotNull ApplicationUser user) {
        PropertySet properties = this.userPropertyManager.getPropertySet(user);
        properties.setText(propertyKey, propertyValue);
    }
}

