/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.project;

import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.project.AssigneeTypeService;
import com.atlassian.greenhopper.service.project.ProjectService;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectServiceImpl
implements ProjectService {
    @Autowired
    com.atlassian.jira.bc.project.ProjectService jiraProjectService;
    @Autowired
    private GlobalPermissionManager globalPermissionManager;
    @Autowired
    private AssigneeTypeService assigneeTypeService;
    @Autowired
    private UserManager userManager;

    @Override
    @Nonnull
    public ServiceOutcome<Project> createProject(ApplicationUser user, String name, String key, String description, String leadUserName, String url, Long assigneeType, Long avatarId, ProjectType projectType) {
        ProjectService.CreateProjectValidationResult validationResult = this.getValidationResult(user, name, key, description, leadUserName, url, assigneeType, avatarId, projectType);
        if (!validationResult.isValid()) {
            return ServiceOutcomeImpl.from(validationResult.getErrorCollection());
        }
        Project project = this.jiraProjectService.createProject(validationResult);
        return ServiceOutcomeImpl.ok(project);
    }

    @Override
    @Nonnull
    public ServiceResult validateCreateProject(ApplicationUser user, String name, String key, String leadUserName) {
        ProjectService.CreateProjectValidationResult validationResult = this.getValidationResult(user, name, key, null, leadUserName, null, null, null, ProjectType.SCRUM);
        return validationResult.isValid() ? ServiceOutcomeImpl.ok() : ServiceOutcomeImpl.from(validationResult.getErrorCollection());
    }

    private ProjectService.CreateProjectValidationResult getValidationResult(ApplicationUser user, String name, String key, String description, String leadUserName, String url, Long assigneeType, Long avatarId, ProjectType projectType) {
        if (!this.assigneeTypeService.isValidType(assigneeType)) {
            assigneeType = 2L;
        }
        ProjectCreationData projectData = new ProjectCreationData.Builder().withName(name).withKey(key).withDescription(description).withLead(this.userManager.getUserByName(leadUserName)).withUrl(url).withAssigneeType(assigneeType).withAvatarId(avatarId).withProjectTemplateKey(this.toProjectTemplateKey(projectType)).withType(new ProjectTypeKey("software")).build();
        return this.jiraProjectService.validateCreateProject(user, projectData);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> deleteProject(ApplicationUser user, Project project) {
        ProjectService.DeleteProjectValidationResult deleteValidationResult = this.jiraProjectService.validateDeleteProject(user, project.getKey());
        if (deleteValidationResult.isValid()) {
            this.jiraProjectService.deleteProject(user, deleteValidationResult);
        }
        return ServiceOutcomeImpl.from(deleteValidationResult.getErrorCollection());
    }

    @Override
    public boolean canCreateProject(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private String toProjectTemplateKey(ProjectType projectType) {
        if (projectType == null) {
            return null;
        }
        switch (projectType) {
            case KANBAN: {
                return "com.pyxis.greenhopper.jira:gh-kanban-template";
            }
            case SCRUM: {
                return "com.pyxis.greenhopper.jira:gh-scrum-template";
            }
            case BASIC_SOFTWARE_DEVELOPMENT: {
                return "com.pyxis.greenhopper.jira:basic-software-development-template";
            }
        }
        return null;
    }
}

