/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.project;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.project.ProjectHistoryService;
import com.atlassian.greenhopper.service.project.ProjectHistoryTransformer;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectHistoryServiceImpl
implements ProjectHistoryService {
    @Autowired
    private UserProjectHistoryManager userProjectHistoryManager;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private ProjectHistoryTransformer projectHistoryTransformer;
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());

    @Override
    public void registerRecentProjects(ApplicationUser user, RapidView rapidView, List<Project> projectsToRegister, String selectedProjectKey) {
        if (projectsToRegister.isEmpty()) {
            this.registerRecentProjectsFromRapidView(user, rapidView, selectedProjectKey);
        } else {
            this.registerRecentProjectsWithProjects(user, projectsToRegister, selectedProjectKey);
        }
    }

    private void registerRecentProjectsFromRapidView(ApplicationUser user, RapidView rapidView, String selectedProjectKey) {
        ServiceOutcome<Query> outcome = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!outcome.isValid()) {
            this.logger.warn("Could not get the query for rapid view '%s' (%d) -- skipping", rapidView.getName(), rapidView.getId());
            this.logger.warn(outcome.getErrors().toString(), new Object[0]);
            return;
        }
        Query rapidViewQuery = outcome.getValue();
        if (this.queryService.isProjectClauseOnlyQuery(rapidViewQuery)) {
            List<Project> projectsInProjectBasedQuery = this.queryService.getProjectsInProjectClauseOnlyQuery(user, rapidViewQuery);
            this.registerRecentProjectsWithProjects(user, projectsInProjectBasedQuery, selectedProjectKey);
        }
    }

    private void registerRecentProjectsWithProjects(ApplicationUser user, List<Project> projectsToRegister, String selectedProjectKey) {
        ArrayList projectHistoryItems = this.userProjectHistoryManager.getProjectHistoryWithoutPermissionChecks(user);
        projectHistoryItems = new ArrayList(projectHistoryItems);
        Iterable projectsInHistory = Iterables.transform(projectHistoryItems, (Function)this.projectHistoryTransformer);
        List<Project> projectRegisterQueue = this.calculateProjectQueue(projectsToRegister, projectsInHistory, selectedProjectKey);
        for (Project projectToRegister : projectRegisterQueue) {
            this.userProjectHistoryManager.addProjectToHistory(user, projectToRegister);
        }
    }

    List<Project> calculateProjectQueue(List<Project> projectsToRegister, Iterable<Project> projectsInHistory, String selectedProjectKey) {
        LinkedList<Project> projectRegisterQueue = new LinkedList<Project>();
        ArrayList remainingProjects = Lists.newArrayList(projectsToRegister);
        for (Project project : projectsInHistory) {
            if (!remainingProjects.contains(project)) continue;
            projectRegisterQueue.addFirst(project);
            remainingProjects.remove(project);
        }
        for (Project unregisteredProject : remainingProjects) {
            projectRegisterQueue.addFirst(unregisteredProject);
        }
        return this.moveSelectedProjectToBottom(projectRegisterQueue, selectedProjectKey);
    }

    private List<Project> moveSelectedProjectToBottom(LinkedList<Project> projects, String selectedProjectKey) {
        if (selectedProjectKey != null && CollectionUtils.isNotEmpty(projects)) {
            int selectedProjectIndex = ProjectHistoryServiceImpl.indexOfSelectedProjectInList(projects, selectedProjectKey);
            if (selectedProjectIndex > -1) {
                Collections.rotate(projects.subList(selectedProjectIndex, projects.size()), -1);
            } else {
                Project selectedProject = this.projectManager.getProjectObjByKey(selectedProjectKey);
                projects.addLast(selectedProject);
            }
        }
        return projects;
    }

    private static int indexOfSelectedProjectInList(List<Project> projects, String selectedProjectKey) {
        int selectedProjectIndex = -1;
        for (int index = 0; index < projects.size(); ++index) {
            if (!StringUtils.equals((CharSequence)selectedProjectKey, (CharSequence)projects.get(index).getKey())) continue;
            selectedProjectIndex = index;
            break;
        }
        return selectedProjectIndex;
    }
}

