/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lucene;

import com.atlassian.greenhopper.service.lucene.RightJoinEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;

public class LeftJoin {
    private final String leftField;
    private final RightJoinEnum rightEnum;

    public LeftJoin(String leftField, RightJoinEnum rightEnum) {
        this.leftField = leftField;
        this.rightEnum = rightEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet computeResult(IndexReader leftReader) throws IOException {
        this.rightEnum.reset();
        try {
            BitSet bs = new BitSet(leftReader.maxDoc());
            while (this.rightEnum.hasNext()) {
                Term term = this.rightEnum.term();
                for (LeafReaderContext context : leftReader.leaves()) {
                    int doc;
                    PostingsEnum postings = context.reader().postings(term);
                    if (postings == null) continue;
                    while ((doc = postings.nextDoc()) != Integer.MAX_VALUE) {
                        bs.set(context.docBase + doc);
                    }
                }
            }
            BitSet bitSet = bs;
            return bitSet;
        }
        finally {
            this.rightEnum.close();
        }
    }
}

