/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lucene;

import com.atlassian.greenhopper.service.lucene.RightJoinEnum;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.Term;

class DocumentFieldRetrievingRightJoinEnum
implements RightJoinEnum {
    private final String field;
    private final List<String> termValues;
    private Iterator<String> issueIdIterator;
    private String current;

    DocumentFieldRetrievingRightJoinEnum(String field, List<String> termValues) {
        this.field = field;
        this.termValues = termValues;
        this.issueIdIterator = this.termValues.iterator();
    }

    @Override
    public void reset() throws IOException {
        this.issueIdIterator = this.termValues.iterator();
    }

    @Override
    public boolean hasNext() throws IOException {
        boolean hasNext = this.issueIdIterator.hasNext();
        if (hasNext) {
            this.current = this.issueIdIterator.next();
        }
        return hasNext;
    }

    @Override
    public Term term() {
        return new Term(this.field, this.current);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String describe() {
        return "Document Field retreiving right-enum [# of terms : " + this.termValues.size() + "]";
    }
}

