/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lucene;

import com.atlassian.greenhopper.jira.JIRAResource;
import com.atlassian.greenhopper.service.lucene.DocumentFieldRetrievingRightJoinEnum;
import com.atlassian.greenhopper.service.lucene.LeftJoin;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangeHistorySearchHelper {
    private static final Logger log = Logger.getLogger(ChangeHistorySearchHelper.class);
    @Autowired
    private IssueIndexManager issueIndexManager;
    @JIRAResource
    private LuceneQueryBuilder luceneQueryBuilder;
    @Autowired
    private PermissionsFilterGenerator permissionsFilterGenerator;

    public BitSet findChangeLogFilter(ApplicationUser user, Query jql) throws SearchException, IOException {
        ManagedIndexSearcher issueSearcher = this.issueIndexManager.getIssueSearcher();
        QueryCreationContextImpl context = new QueryCreationContextImpl(user, false);
        Object whereQuery = jql.getWhereClause() != null ? this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)context, jql.getWhereClause()) : new MatchAllDocsQuery();
        org.apache.lucene.search.Query permissionQuery = this.permissionsFilterGenerator.getQuery(user);
        BooleanQuery.Builder issueIndexQuery = new BooleanQuery.Builder();
        issueIndexQuery.add((org.apache.lucene.search.Query)whereQuery, BooleanClause.Occur.MUST);
        issueIndexQuery.add(permissionQuery, BooleanClause.Occur.MUST);
        log.trace((Object)String.format("Lucene query for issue index (user query + permissions): [%s]", issueIndexQuery));
        IssueIdTermHitCollector collector = new IssueIdTermHitCollector();
        issueSearcher.search((org.apache.lucene.search.Query)issueIndexQuery.build(), (Collector)collector);
        List<String> issueIds = collector.getIssueIds();
        DocumentFieldRetrievingRightJoinEnum joinEnum = new DocumentFieldRetrievingRightJoinEnum("issue_id", issueIds);
        LeftJoin join = new LeftJoin("issue_id", joinEnum);
        BitSet historyIndexDocIds = join.computeResult(this.issueIndexManager.getChangeHistorySearcher().getIndexReader());
        return historyIndexDocIds;
    }

    private static class IssueIdTermHitCollector
    extends FieldDocumentHitCollector {
        private static final Set<String> FIELDS = ImmutableSet.of((Object)"issue_id");
        private List<String> issueIds = new ArrayList<String>(500);

        IssueIdTermHitCollector() {
        }

        protected Set<String> getFieldsToLoad() {
            return FIELDS;
        }

        public void collect(Document document) {
            this.issueIds.add(document.get("issue_id"));
        }

        public List<String> getIssueIds() {
            return this.issueIds;
        }
    }
}

