/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.logging;

import com.atlassian.jira.config.util.JiraHome;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggingConfiguration {
    private static final Logger log = Logger.getLogger(LoggingConfiguration.class);
    private static final String[] GENERAL_AGILE_LOGGER_NAMES = new String[]{"com.atlassian.greenhopper", "com.pyxis"};
    private static final String ATLASSIAN_GREENHOPPER = "atlassian-greenhopper";
    @Autowired
    private JiraHome jiraHome;

    public void configureAgileLoggers() {
        Appender ourAppender = null;
        for (String loggerName : GENERAL_AGILE_LOGGER_NAMES) {
            Logger logger = Logger.getLogger((String)loggerName);
            logger.setLevel(Level.INFO);
            logger.setAdditivity(false);
            if (logger.getAppender(ATLASSIAN_GREENHOPPER) != null) continue;
            ourAppender = ourAppender == null ? this.createOurAppender() : ourAppender;
            logger.addAppender(ourAppender);
        }
    }

    private Appender createOurAppender() {
        try {
            PatternLayout layout = new PatternLayout("%d %t %p %X{jira.username} %X{jira.request.id} %X{jira.request.assession.id} %X{jira.request.ipaddr} %X{jira.request.url} [%c{4}] %m%n");
            String fileName = new File(this.jiraHome.getLogDirectory(), "atlassian-greenhopper.log").getAbsolutePath();
            RollingFileAppender appender = new RollingFileAppender((Layout)layout, fileName, true);
            appender.setName(ATLASSIAN_GREENHOPPER);
            appender.setMaxFileSize("20480KB");
            appender.setMaxBackupIndex(5);
            return appender;
        }
        catch (IOException ioe) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to initialise GreenHopper log4j support", ioe);
            log.error((Object)illegalStateException.getMessage());
            throw illegalStateException;
        }
    }
}

