/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.logging;

import com.atlassian.greenhopper.api.customfield.ManagedCustomFieldsService;
import com.atlassian.greenhopper.api.issuelink.ManagedIssueLinkTypesService;
import com.atlassian.greenhopper.api.issuetype.ManagedIssueTypesService;
import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogSupportInfo {
    private static final String STARTED = "started";
    private static final String ENDED = "ended";
    @Autowired
    private UpgradeVersionService upgradeVersionService;
    @Autowired
    private ManagedIssueTypesService managedIssueTypesService;
    @Autowired
    private ManagedCustomFieldsService managedCustomFieldsService;
    @Autowired
    private ManagedIssueLinkTypesService managedIssueLinkTypesService;
    @Autowired
    private RankService rankService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public void logSupportInfoOnStartup(Logger log) {
        UpgradeVersionService.PluginRunInfo prevPluginRunInfo = this.upgradeVersionService.recordPluginStarted();
        if (prevPluginRunInfo.isDowngrade()) {
            this.showDownGradeMessage(log, prevPluginRunInfo);
        }
        this.showPluginRunHistory(log);
        this.showUpgradeTaskHistory(log);
    }

    public void logSupportInfoOnFullSystemStartLicensed(Logger log) {
        try {
            this.showStoredProperties(log);
        }
        catch (Exception e) {
            log.warn((Object)"Could not log stored properties due to exception", (Throwable)e);
        }
    }

    private void showDownGradeMessage(Logger log, UpgradeVersionService.PluginRunInfo prevPluginRunInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n").append("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!").append("\n\n").append("\tIt appears that you have DOWNGRADED your version of JIRA Agile").append("\n\n").append("\tThe current version is ").append(prevPluginRunInfo.getCurrentVersion()).append("\n").append("\tThe previous version was ").append(prevPluginRunInfo.getPreviousVersion()).append("\n").append("\n").append("\tWe do not recommend that you DOWNGRADE as it can lead to data corruption.").append("\n\n").append("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!").append("\n\n");
        log.error((Object)sb);
    }

    private void showPluginRunHistory(Logger log) {
        List<UpgradeVersionService.PluginRunInfo> pluginRunHistory = this.upgradeVersionService.getPluginRunHistory();
        if (pluginRunHistory.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nJIRA Agile Run History\n");
        int i = 0;
        for (UpgradeVersionService.PluginRunInfo runInfo : pluginRunHistory) {
            sb.append("\n").append("\t").append(i == pluginRunHistory.size() - 1 ? "*" : "").append("JIRA Agile v").append(runInfo.getPreviousVersion()).append(" (").append(runInfo.getPreviousChangeSet()).append(")").append(" started at ").append(runInfo.getRanOnStr()).append("\n");
            ++i;
        }
        sb.append("\n");
        log.info((Object)sb.toString());
    }

    private void showUpgradeTaskHistory(Logger log) {
        List<UpgradeVersionService.UpgradeHistoryDetail> upgradeHistory = this.upgradeVersionService.getUpgradeHistory();
        if (upgradeHistory.isEmpty()) {
            log.info((Object)"There does not appear to be any JIRA Agile upgrade history");
            log.info((Object)"This can be ok as upgrade history was not introduced until JIRA Agile v5.10.3");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nThe following JIRA Agile upgrade tasks have been run on this system\n");
        for (UpgradeVersionService.UpgradeHistoryDetail detail : upgradeHistory) {
            String startedOrEnded = detail.isStartRecord() ? StringUtils.rightPad((String)STARTED, (int)STARTED.length()) : StringUtils.rightPad((String)ENDED, (int)STARTED.length());
            sb.append("\n").append("\tJAG UpgradeTask ").append(StringUtils.leftPad((String)detail.getBuildNumber(), (int)3)).append(" ").append(startedOrEnded).append(" at ").append(detail.getRanOnStr()).append(" within JAG v").append(detail.getPluginVersion()).append(" (").append(detail.getChangeSet()).append(")");
            if (!StringUtils.isNotBlank((CharSequence)detail.getTimeTaken())) continue;
            sb.append(" and took ").append(detail.getTimeTaken()).append(" ms");
        }
        sb.append("\n");
        log.info((Object)sb.toString());
    }

    private void showStoredProperties(Logger log) throws Exception {
        ServiceOutcome<IssueType> epicIssueType = this.managedIssueTypesService.getEpicIssueType();
        ServiceOutcome<IssueType> storyIssueType = this.managedIssueTypesService.getStoryIssueType();
        ServiceOutcome<CustomField> epicColorCustomField = this.managedCustomFieldsService.getEpicColorCustomField();
        ServiceOutcome<CustomField> epicLinkCustomField = this.managedCustomFieldsService.getEpicLinkCustomField();
        ServiceOutcome<CustomField> epicNameCustomField = this.managedCustomFieldsService.getEpicNameCustomField();
        ServiceOutcome<CustomField> epicStatusCustomField = this.managedCustomFieldsService.getEpicStatusCustomField();
        ServiceOutcome<CustomField> sprintCustomField = this.managedCustomFieldsService.getSprintCustomField();
        ServiceOutcome<CustomField> storyPointsCustomField = this.managedCustomFieldsService.getStoryPointsCustomField();
        ServiceOutcome<CustomField> defaultRankField = this.rankService.getDefaultRankField();
        ServiceOutcome<IssueLinkType> epicLinkIssueLinkType = this.managedIssueLinkTypesService.getEpicLinkIssueLinkType();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nManaged Issue Types\n");
        this.appendIssueType("Epic", "gh.issue.epic", epicIssueType, sb);
        this.appendIssueType("Story", "gh.issue.story", storyIssueType, sb);
        sb.append("\n\nManaged Custom Fields\n");
        this.appendCustomField("Epic Colour", epicColorCustomField, sb);
        this.appendCustomField("Epic Link", epicLinkCustomField, sb);
        this.appendCustomField("Epic Name", epicNameCustomField, sb);
        this.appendCustomField("Epic Status", epicStatusCustomField, sb);
        this.appendCustomField("Default Global Rank", defaultRankField, sb);
        this.appendCustomField("Sprint", sprintCustomField, sb);
        this.appendCustomField("Story Points", storyPointsCustomField, sb);
        sb.append("\n\nManaged Issue Link Types\n");
        this.appendIssueLinkType("Epic Link Issue Link Type", epicLinkIssueLinkType, sb);
        log.info((Object)sb.toString());
    }

    private void appendIssueType(String ref, String expectedKey, ServiceOutcome<IssueType> issueType, StringBuilder sb) {
        sb.append("\t").append(StringUtils.rightPad((String)ref, (int)32));
        if (issueType.isValid()) {
            IssueType value = (IssueType)issueType.getReturnedValue();
            sb.append("id=").append(StringUtils.rightPad((String)value.getId(), (int)24)).append("name=").append(StringUtils.rightPad((String)value.getName(), (int)32));
            String expectedNameInDefaultLocale = this.i18nFactoryService.getI18n().getText(expectedKey);
            String defaultLocale = this.applicationProperties.getDefaultLocale().toString();
            String actualNameInDefaultLocale = value.getNameTranslation(defaultLocale);
            if (actualNameInDefaultLocale == null) {
                actualNameInDefaultLocale = value.getName();
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)actualNameInDefaultLocale, (CharSequence)expectedNameInDefaultLocale)) {
                sb.append(" <<< WARN name is different from expected: ").append(expectedNameInDefaultLocale).append(" (using locale ").append(defaultLocale).append(")");
            }
        } else {
            sb.append("Could not load issue type. Error: ").append(issueType.getErrorCollection());
        }
        sb.append("\n");
    }

    private void appendCustomField(String ref, ServiceOutcome<CustomField> customField, StringBuilder sb) {
        sb.append("\t").append(StringUtils.rightPad((String)ref, (int)32));
        if (customField.isValid()) {
            CustomField value = (CustomField)customField.getReturnedValue();
            sb.append("id=").append(StringUtils.rightPad((String)value.getId(), (int)24)).append("name=").append(StringUtils.rightPad((String)value.getName(), (int)32)).append("type=").append(value.getCustomFieldType().getKey());
        } else {
            sb.append("Could not load custom field. Error: ").append(customField.getErrorCollection());
        }
        sb.append("\n");
    }

    private void appendIssueLinkType(String ref, ServiceOutcome<IssueLinkType> issueLinkType, StringBuilder sb) {
        sb.append("\t").append(StringUtils.rightPad((String)ref, (int)32));
        if (issueLinkType.isValid()) {
            IssueLinkType value = (IssueLinkType)issueLinkType.getReturnedValue();
            sb.append("id=").append(StringUtils.rightPad((String)value.getId().toString(), (int)24)).append("name=").append(StringUtils.rightPad((String)value.getName(), (int)32));
        } else {
            sb.append("Could not load issue link type. Error: ").append(issueLinkType.getErrorCollection());
        }
        sb.append("\n");
    }
}

