/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.logging;

import com.atlassian.greenhopper.service.logging.LogSupportInfo;
import com.atlassian.greenhopper.util.BuildProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-LogSupport")
public class LogSupport {
    public static final String SERVICE = "gh-LogSupport";
    private static final Logger log = Logger.getLogger(LogSupport.class);
    private static final String MARKER_LINE = "*********************************************************************************\n";
    private static final Logger AGILE_SUPPORT_LOGGER = Logger.getLogger((String)"com.atlassian.agile.support");
    private final BuildProperties buildProperties;
    private final LogSupportInfo logSupportInfo;

    @Autowired
    public LogSupport(BuildProperties buildProperties, LogSupportInfo logSupportInfo) {
        this.buildProperties = buildProperties;
        this.logSupportInfo = logSupportInfo;
        AGILE_SUPPORT_LOGGER.setLevel(Level.INFO);
    }

    public void onPluginStarting() {
        this.logPluginMessage("plugin starting...");
        this.logSupportInfo.logSupportInfoOnStartup(log);
    }

    public void onPluginStarted() {
        this.logPluginMessage("plugin started.  Get Agile!");
    }

    public void onPluginStopping() {
        this.logPluginMessage("plugin stopping...");
    }

    public void onPluginStopped() {
        this.logPluginMessage("plugin stopped");
    }

    public void onClearCache() {
        this.logPluginMessage("onClearCache() - clearing cache state");
    }

    public void onFullSystemStartLicensed() {
        this.logSupportInfo.logSupportInfoOnFullSystemStartLicensed(log);
    }

    private void logPluginMessage(String msg) {
        StringBuilder sb = new StringBuilder().append("Atlassian GreenHopper v").append(this.buildProperties.getVersion()).append(" #").append(this.buildProperties.getChangeSet()).append(" built ").append(this.buildProperties.getBuildDate()).append(" - ").append(msg).append("\n");
        String pluginLogMsg = "\n\n*********************************************************************************\n" + sb + MARKER_LINE;
        log.info((Object)pluginLogMsg);
        AGILE_SUPPORT_LOGGER.info((Object)pluginLogMsg);
    }
}

