/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.SqlPositionFunction;
import com.atlassian.greenhopper.manager.lexorank.SqlSelectStatement;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import com.atlassian.greenhopper.util.database.DatabaseType;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.Common;

class RankOutOfBoundaryCheck
extends AbstractLexoRankIntegrityCheck {
    public RankOutOfBoundaryCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Rank out of bounds check";
    }

    @Override
    public String getDescription() {
        return "Checks if there is a rank value for the rank field that is out of bounds.";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankDaoContext lexoRankDaoContext = this.lexoRankDao.getContext();
        LexoRankEntityDetails entityDetails = lexoRankDaoContext.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlPositionFunction sqlPositionOfDecimalCharFunction = SqlPositionFunction.builder().indexOf(":").inColumn(rankColumnName).build();
        SqlPositionFunction sqlPositionOfMinusCharFunction = SqlPositionFunction.builder().indexOf("-").inColumn(rankColumnName).build();
        DatabaseType databaseType = lexoRankDaoContext.getDatabaseType();
        SqlSelectStatement sqlSelectStatement = SqlSelectStatement.builder(entityDetails, databaseType).select("DISTINCT " + rankColumnName).where(fieldIdColumnName + " = ? AND (" + sqlPositionOfDecimalCharFunction.toSql(databaseType) + " != 9 OR " + sqlPositionOfMinusCharFunction.toSql(databaseType) + " != 0)", rankFieldId).build();
        ResultSet resultSet = null;
        try {
            resultSet = sqlSelectStatement.execute();
            List<String> outOfBoundaryRanks = this.getOutOfBoundaryRanks(resultSet);
            if (outOfBoundaryRanks.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.fail("Found the following rank value(s) for rank field[id=%d] that are out of bounds: %s", rankFieldId, Joiner.on((String)", ").join(outOfBoundaryRanks));
            return bl;
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            sqlSelectStatement.close();
        }
    }

    private List<String> getOutOfBoundaryRanks(ResultSet resultSet) throws SQLException {
        ArrayList outOfBoundRanks = Lists.newArrayList();
        while (resultSet.next()) {
            outOfBoundRanks.add(resultSet.getString(1));
        }
        return outOfBoundRanks;
    }
}

