/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;

class MarkerRowsPresentCheck
extends AbstractLexoRankIntegrityCheck {
    public MarkerRowsPresentCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Marker rows present in table for rank field";
    }

    @Override
    public String getDescription() {
        return "Checks if the rank table has been properly initialized for the rank field. A minimum and maximum marker row are expected to be present in the table for the rank field.";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        if (!maximumMarkerRow.getType().equals((Object)LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW)) {
            return this.fail("expected the maximum marker row. Instead found %s", maximumMarkerRow);
        }
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        if (!minimumMarkerRow.getType().equals((Object)LexoRankRow.RankRowType.MINIMUM_MARKER_ROW)) {
            return this.fail("expected the minimum marker row. Instead found %s", maximumMarkerRow);
        }
        return true;
    }
}

