/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.model.lexorank.LexoDecimal;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;

class MarkerRowsCorrectCheck
extends AbstractLexoRankIntegrityCheck {
    public MarkerRowsCorrectCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Marker rows correctness check";
    }

    @Override
    public String getDescription() {
        return "Checks whether the marker rows for a rank field have the expected rank value.";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        if (minimumMarkerRow.getRank() == null) {
            return this.fail("Minimum marker row does not have a rank value.", new Object[0]);
        }
        LexoRank minimumRank = LexoRank.parse(minimumMarkerRow.getRank());
        LexoDecimal minimumRankDecimal = minimumRank.getDecimal();
        if (!minimumRankDecimal.equals(LexoRank.min().getDecimal())) {
            return this.fail("Minimum marker row's rank does not equal the minimum rank. Actual minimum rank [%s], expected minimum rank [%s].", minimumRankDecimal.format(), LexoRank.min().getDecimal().format());
        }
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        if (maximumMarkerRow.getRank() == null) {
            return this.fail("Maximum marker row does not have a rank value.", new Object[0]);
        }
        LexoRank maximumRank = LexoRank.parse(maximumMarkerRow.getRank());
        LexoDecimal maximumRankDecimal = maximumRank.getDecimal();
        if (!maximumRankDecimal.equals(LexoRank.max().getDecimal())) {
            return this.fail("Maximum marker row's rank does not equal the maximum rank. Actual maximum rank [%s], expected maximum rank [%s]", maximumRankDecimal.format(), LexoRank.max().getDecimal().format());
        }
        return true;
    }
}

