/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;

class MarkerRowsBucketCheck
extends AbstractLexoRankIntegrityCheck {
    public MarkerRowsBucketCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Marker rows in valid bucket check.";
    }

    @Override
    public String getDescription() {
        return "Checks if the marker rows of a rank field are in valid bucket(s).";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankBucket maximumBucket;
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        LexoRank minimumRank = LexoRank.parse(minimumMarkerRow.getRank());
        LexoRank maximumRank = LexoRank.parse(maximumMarkerRow.getRank());
        LexoRankBucket minimumBucket = minimumRank.getBucket();
        if (minimumBucket.equals((Object)(maximumBucket = maximumRank.getBucket()))) {
            return true;
        }
        if (minimumBucket.equals((Object)LexoRankBucket.BUCKET_0) && maximumBucket.equals((Object)LexoRankBucket.BUCKET_1)) {
            return true;
        }
        if (minimumBucket.equals((Object)LexoRankBucket.BUCKET_1) && maximumBucket.equals((Object)LexoRankBucket.BUCKET_2)) {
            return true;
        }
        if (minimumBucket.equals((Object)LexoRankBucket.BUCKET_0) && maximumBucket.equals((Object)LexoRankBucket.BUCKET_2)) {
            return true;
        }
        return this.fail("Illegal bucket state: minimum marker row is in bucket %s, maximum marker row is in bucket %s", minimumBucket.format(), maximumBucket.format());
    }
}

