/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryDao;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.BalanceEntryCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.BucketFieldCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.DuplicateRanksCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.IssueRankNotSameAsMarkerRanksCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.IssueRowsBucketCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityCheckReport;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityChecker;
import com.atlassian.greenhopper.service.lexorank.integrity.MarkerRowsBucketCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.MarkerRowsCorrectCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.MarkerRowsPresentCheck;
import com.atlassian.greenhopper.service.lexorank.integrity.RankOutOfBoundaryCheck;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.task.LoggingProgressSink;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.ListUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankIntegrityCheckerImpl
implements LexoRankIntegrityChecker {
    @Autowired
    private LexoRankDao lexoRankDao;
    @Autowired
    private BalancerEntryDao balancerEntryDao;
    private List<AbstractLexoRankIntegrityCheck> healthChecks;
    private List<AbstractLexoRankIntegrityCheck> fullChecks;

    @PostConstruct
    public void init() {
        this.healthChecks = Arrays.asList(new MarkerRowsPresentCheck(this.lexoRankDao), new MarkerRowsCorrectCheck(this.lexoRankDao), new MarkerRowsBucketCheck(this.lexoRankDao), new RankOutOfBoundaryCheck(this.lexoRankDao), new IssueRankNotSameAsMarkerRanksCheck(this.lexoRankDao), new IssueRowsBucketCheck(this.lexoRankDao), new BalanceEntryCheck(this.lexoRankDao, this.balancerEntryDao), new BucketFieldCheck(this.lexoRankDao));
        this.fullChecks = ListUtils.union(this.healthChecks, Collections.singletonList(new DuplicateRanksCheck(this.lexoRankDao)));
    }

    @Override
    public ServiceOutcome<LexoRankIntegrityCheckReport> performHealthChecks(CustomField rankField) {
        return this.runChecks(this.healthChecks, rankField);
    }

    @Override
    public ServiceOutcome<LexoRankIntegrityCheckReport> performFullIntegrityChecks(CustomField rankField) {
        return this.runChecks(this.fullChecks, rankField);
    }

    private ServiceOutcome<LexoRankIntegrityCheckReport> runChecks(List<AbstractLexoRankIntegrityCheck> checks, CustomField rankField) {
        LexoRankIntegrityCheckReport.Builder reportBuilder = LexoRankIntegrityCheckReport.builder().setRankFieldId(rankField.getIdAsLong()).setRankFieldName(rankField.getFieldName());
        IntegrityCheckerProgressSink progressSink = new IntegrityCheckerProgressSink(rankField, checks.size());
        checks.forEach(check -> {
            reportBuilder.addResult(this.executeCheck(rankField.getIdAsLong(), (AbstractLexoRankIntegrityCheck)check));
            progressSink.makeProgress();
        });
        return ServiceOutcomeImpl.ok(reportBuilder.build());
    }

    private LexoRankIntegrityCheckReport.Result executeCheck(Long rankFieldId, AbstractLexoRankIntegrityCheck check) {
        LexoRankIntegrityCheckReport.Result result = new LexoRankIntegrityCheckReport.Result();
        result.name = check.getName();
        result.description = check.getDescription();
        result.passed = check.performCheck(rankFieldId);
        result.failureReason = check.getFailureReason();
        result.fatal = check.isFatal();
        return result;
    }

    private class IntegrityCheckerProgressSink {
        private StepTaskProgressSink progressSink;
        private int currentStep = 0;

        private IntegrityCheckerProgressSink(CustomField rankField, int steps) {
            String progressMessageTemplate = String.format("Checking LexoRank integrity for rank field [id=%s, name=%s] {0}%% complete.", rankField.getIdAsLong(), rankField.getFieldName());
            LoggingProgressSink loggingProgressSink = new LoggingProgressSink(Logger.getLogger(LexoRankIntegrityCheckerImpl.class), progressMessageTemplate, 0);
            this.progressSink = new StepTaskProgressSink(0L, 100L, (long)steps, (TaskProgressSink)loggingProgressSink);
        }

        public void makeProgress() {
            ++this.currentStep;
            this.progressSink.makeProgress((long)this.currentStep, "", "");
        }
    }
}

