/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class LexoRankIntegrityCheckReport {
    @XmlElement
    private Long rankFieldId;
    @XmlElement
    private String rankFieldName;
    @XmlElement
    private List<Result> results = Lists.newArrayList();

    private LexoRankIntegrityCheckReport(Long rankFieldId, String rankFieldName, List<Result> results) {
        this.rankFieldId = rankFieldId;
        this.rankFieldName = rankFieldName;
        this.results = results;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Long getRankFieldId() {
        return this.rankFieldId;
    }

    public String getRankFieldName() {
        return this.rankFieldName;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public static class Builder {
        private Long rankFieldId;
        private String rankFieldName;
        private List<Result> results = Lists.newArrayList();

        public Builder setRankFieldId(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        public Builder setRankFieldName(String rankFieldName) {
            this.rankFieldName = rankFieldName;
            return this;
        }

        public Builder addResult(Result result) {
            this.results.add(result);
            return this;
        }

        public LexoRankIntegrityCheckReport build() {
            return new LexoRankIntegrityCheckReport(this.rankFieldId, this.rankFieldName, this.results);
        }
    }

    @XmlRootElement
    public static class Result {
        @XmlElement
        public String name;
        @XmlElement
        public String description;
        @XmlElement
        public boolean passed;
        @XmlElement
        public String failureReason;
        @XmlElement
        public boolean fatal;
    }
}

