/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.SqlSelectStatement;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import com.atlassian.greenhopper.util.database.DatabaseType;
import java.sql.ResultSet;
import net.java.ao.Common;

class IssueRowsBucketCheck
extends AbstractLexoRankIntegrityCheck {
    public IssueRowsBucketCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Issue rows in valid bucket check.";
    }

    @Override
    public String getDescription() {
        return "Checks if the issue rows of a rank field are in a valid bucket. Issue rows should be in one of the buckets the marker rows are in.";
    }

    @Override
    public boolean isFatal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        LexoRank minimumRank = LexoRank.parse(minimumMarkerRow.getRank());
        LexoRank maximimumRank = LexoRank.parse(maximumMarkerRow.getRank());
        LexoRankBucket minimumRankBucket = minimumRank.getBucket();
        LexoRankBucket maximumRankBucket = maximimumRank.getBucket();
        LexoRankDaoContext context = this.lexoRankDao.getContext();
        LexoRankEntityDetails entityDetails = context.getEntityDetails();
        DatabaseType databaseType = context.getDatabaseType();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String typeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement sqlSelectStatement = SqlSelectStatement.builder(entityDetails, databaseType).count().where(fieldIdColumnName + " = ? AND " + typeColumnName + " = ? AND " + rankColumnName + " NOT LIKE ? AND " + rankColumnName + " NOT LIKE ?", rankFieldId, LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId(), minimumRankBucket.format() + "|%", maximumRankBucket.format() + "|%").build();
        ResultSet resultSet = null;
        try {
            int count;
            resultSet = sqlSelectStatement.execute();
            if (resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                boolean bl = this.fail("%s issue rank rows are in a bucket different than the minimum or maximum rank for rank field[id=%]", count, rankFieldId);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            sqlSelectStatement.close();
        }
    }
}

