/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.SqlSelectStatement;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import com.atlassian.greenhopper.util.database.DatabaseType;
import java.sql.ResultSet;
import net.java.ao.Common;

class IssueRankNotSameAsMarkerRanksCheck
extends AbstractLexoRankIntegrityCheck {
    public IssueRankNotSameAsMarkerRanksCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Issue ranks different from marker ranks check";
    }

    @Override
    public String getDescription() {
        return "Checks if there are any issue ranks that have the same rank as the maximum or minimum rank.";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankDaoContext context = this.lexoRankDao.getContext();
        LexoRankEntityDetails entityDetails = context.getEntityDetails();
        DatabaseType databaseType = context.getDatabaseType();
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String whereStatement = typeColumnName + " = ? AND " + fieldIdColumnName + " = ? AND NOT   (     (" + rankColumnName + " > ? AND " + rankColumnName + " < ?) OR     (" + rankColumnName + " > ? AND " + rankColumnName + " < ?) OR     (" + rankColumnName + " > ? AND " + rankColumnName + " < ?)   )";
        SqlSelectStatement sqlSelectStatement = SqlSelectStatement.builder(entityDetails, databaseType).count().where(whereStatement, (int)LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId(), rankFieldId, LexoRank.from(LexoRankBucket.BUCKET_0, LexoRank.MIN_DECIMAL).toString(), LexoRank.from(LexoRankBucket.BUCKET_0, LexoRank.MAX_DECIMAL).toString(), LexoRank.from(LexoRankBucket.BUCKET_1, LexoRank.MIN_DECIMAL).toString(), LexoRank.from(LexoRankBucket.BUCKET_1, LexoRank.MAX_DECIMAL).toString(), LexoRank.from(LexoRankBucket.BUCKET_2, LexoRank.MIN_DECIMAL).toString(), LexoRank.from(LexoRankBucket.BUCKET_2, LexoRank.MAX_DECIMAL).toString()).build();
        ResultSet resultSet = null;
        try {
            int count;
            resultSet = sqlSelectStatement.execute();
            if (resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                boolean bl = this.fail("Detected %s issue rows that have the same rank value as one of the marker rows' rank", count);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            sqlSelectStatement.close();
        }
    }
}

