/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import java.util.Map;

class DuplicateRanksCheck
extends AbstractLexoRankIntegrityCheck {
    public DuplicateRanksCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Duplicate ranks check";
    }

    @Override
    public String getDescription() {
        return "Checks if there are any duplicate rank values for a rank field.";
    }

    @Override
    public boolean isFatal() {
        return false;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        Map<String, Long> countByRankMap = this.lexoRankDao.countDuplicateRowsForFieldId(rankFieldId);
        if (!countByRankMap.isEmpty()) {
            return this.fail("Detected duplicate ranks for rank field %s : %s", rankFieldId, countByRankMap);
        }
        return true;
    }
}

