/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;

public class BucketFieldCheck
extends AbstractLexoRankIntegrityCheck {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    public BucketFieldCheck(LexoRankDao lexoRankDao) {
        super(lexoRankDao);
    }

    @Override
    public String getName() {
        return "Bucket field check";
    }

    @Override
    public String getDescription() {
        return "Checks that the bucket field in the rank table matches the bucket digit stored in the rank field for all valid bucket values";
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        long numRowsWithInvalidBucket = this.lexoRankDao.getNumRowsWithInvalidBucket(rankFieldId);
        if (numRowsWithInvalidBucket > 0L) {
            this.log.error("LEXORANK table contains %d rows with invalid BUCKET values.", numRowsWithInvalidBucket);
            return this.fail("Found " + numRowsWithInvalidBucket + " rows with value in BUCKET field not matching RANK field.", new Object[0]);
        }
        return true;
    }
}

