/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryAO;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryDao;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.lexorank.integrity.AbstractLexoRankIntegrityCheck;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

class BalanceEntryCheck
extends AbstractLexoRankIntegrityCheck {
    private BalancerEntryDao balancerEntryDao;

    public BalanceEntryCheck(LexoRankDao lexoRankDao, BalancerEntryDao balancerEntryDao) {
        super(lexoRankDao);
        this.balancerEntryDao = balancerEntryDao;
    }

    @Override
    public String getName() {
        return "Balance status check";
    }

    @Override
    public String getDescription() {
        return "Checks if there is a correct balance entry is present or absent for the rank field.";
    }

    @Override
    public boolean isFatal() {
        return false;
    }

    @Override
    protected boolean check(Long rankFieldId) throws Exception {
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        LexoRank minimumRank = LexoRank.parse(minimumMarkerRow.getRank());
        LexoRank maximumRank = LexoRank.parse(maximumMarkerRow.getRank());
        if (minimumRank.getBucket().equals((Object)maximumRank.getBucket())) {
            DateTime oneHourAgo;
            DateTime scheduledBalanceTime;
            BalancerEntryAO balancerEntryAO = this.balancerEntryDao.get(rankFieldId);
            if (balancerEntryAO != null && (scheduledBalanceTime = new DateTime((Object)balancerEntryAO.getRebalanceTime())).isBefore((ReadableInstant)(oneHourAgo = DateTime.now().minusHours(1)))) {
                return this.fail("Both marker rows of rank field[id=%s] are in bucket %s, but an entry in balance entry table was found for the rank field that was scheduled to run more than 1 hour ago. The scheduled job might not be working.", rankFieldId, minimumRank.getBucket().format());
            }
        } else {
            BalancerEntryAO balancerEntryAO = this.balancerEntryDao.get(rankFieldId);
            if (balancerEntryAO == null) {
                return this.fail("Marker rows of rank field[id=%s] are in different buckets. A balance is assumed to be in progress, but no entry for the balance operation was found in the balance entry table.", rankFieldId);
            }
        }
        return true;
    }
}

