/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.integrity;

import com.atlassian.greenhopper.global.PerformanceLogger;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;

abstract class AbstractLexoRankIntegrityCheck {
    protected LexoRankDao lexoRankDao;
    protected String failureReason;
    protected Exception exception;

    public AbstractLexoRankIntegrityCheck(LexoRankDao lexoRankDao) {
        this.lexoRankDao = lexoRankDao;
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract boolean isFatal();

    public String getFailureReason() {
        return this.failureReason;
    }

    protected boolean fail(String failureReason, Object ... parameters) {
        this.failureReason = parameters.length > 0 ? String.format(failureReason, parameters) : failureReason;
        return false;
    }

    protected abstract boolean check(Long var1) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performCheck(Long rankFieldId) {
        String logName = this.getClass().getSimpleName();
        try (PerformanceLogger p = PerformanceLogger.info(PerformanceLogger.Threshold.ABOVE100MS, logName, new Object[0]);){
            boolean bl = this.check(rankFieldId);
            return bl;
        }
        catch (Exception e) {
            this.exception = e;
            this.failureReason = e.getMessage();
            return false;
        }
    }
}

