/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntry;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryManager;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancer;
import com.google.common.collect.Lists;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankScheduledBalanceHandler
implements Runnable {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private BalancerEntryManager balancerEntryManager;
    @Autowired
    private LexoRankBalancer lexoRankBalancer;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    private volatile boolean isRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.log.debug("Executing LexoRank scheduled balance", new Object[0]);
            this.isRunning = true;
            List<BalancerEntry> entriesToBalance = this.balancerEntryManager.list();
            this.log.debug("Balancer table contains %d balancer entries", entriesToBalance.size());
            for (BalancerEntry balancerEntry : entriesToBalance) {
                DateTime rebalanceTime = balancerEntry.getRebalanceTime();
                if (this.log.isDebugEnabled()) {
                    DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");
                    this.log.debug("Balancer entry fieldId=%d rebalanceTime=%s", balancerEntry.getFieldId(), formatter.print((ReadableInstant)rebalanceTime));
                }
                if (rebalanceTime.isBeforeNow() || rebalanceTime.isEqualNow()) {
                    this.log.debug("Balancing fieldId=%d", balancerEntry.getFieldId());
                    ServiceResult balanceFieldsOutcome = this.lexoRankBalancer.balanceFieldIds(Lists.newArrayList((Object[])new Long[]{balancerEntry.getFieldId()}));
                    if (balanceFieldsOutcome.isValid()) {
                        this.log.debug("balance for fieldId=%d succeeded, removing balancer entry", balancerEntry.getFieldId());
                        this.balancerEntryManager.delete(balancerEntry);
                        continue;
                    }
                    this.log.warn("Balance for fieldId=%d returned errors: %s", balancerEntry.getFieldId(), this.errorCollectionTransformer.toJiraErrorCollection(balanceFieldsOutcome.getErrors()));
                    continue;
                }
                this.log.debug("Balance NOT required for fieldId=%d", balancerEntry.getFieldId());
            }
        }
        finally {
            this.isRunning = false;
            this.log.debug("LexoRank scheduled balance finished", new Object[0]);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

