/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntry;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryManager;
import com.atlassian.greenhopper.manager.lexorank.suspend.LexoRankSuspendManager;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancePluginJob;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankChangeEvent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankScheduledBalanceHandler;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperationFactory;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.plugin.event.events.PluginFrameworkShuttingDownEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankBalancingService {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String LEXO_RANK_SCHEDULER_JOB = "LEXO_RANK_SCHEDULER_JOB";
    private static final long SCHEDULER_JOB_REPEAT_INTERVAL = 60000L;
    static final int MIN_RANK_LENGTH_FOR_IMMEDIATE_REBALANCE = 100;
    static final int MIN_RANK_LENGTH_FOR_REBALANCE = 50;
    private static final int HOURS_12 = 12;
    private static final String GH_SHUTDOWN_TRIGGER_KEY = "com.pyxis.greenhopper.jira:sprint-remote-link-aggregator";
    private static final String JIRA_AGILE_LEXORANK_BALANCING_BACKOFF_THRESHOLD = "jira.agile.lexorank.balancing.backoff.threshold";
    private static final long DEFAULT_LEXORANK_BALANCING_BACKOFF_THRESHOLD_IN_MILLIS = 30000L;
    @Autowired
    private LexoRankDao lexoRankDao;
    @Autowired
    private BalancerEntryManager balancerEntryManager;
    @Autowired
    private CompatibilityPluginScheduler compatibilityPluginScheduler;
    private final ThreadPoolExecutor executorService = new LexoRankExecutor();
    @Autowired
    private LexoRankScheduledBalanceHandler lexoRankScheduledBalanceHandler;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private LexoRankBalancePluginJob lexoRankBalancePluginJob;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private JiraProperties jiraProperties;
    @Autowired
    private LexoRankSuspendManager lexoRankSuspendManager;
    private static final ReplicatedIndexOperationFactory operationFactory = new ReplicatedIndexOperationFactory();
    private final AtomicBoolean isServiceInitialised = new AtomicBoolean(false);
    private final AtomicBoolean isBalancingDisabled = new AtomicBoolean(true);
    private final AtomicBoolean isServiceShutdown = new AtomicBoolean(false);

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void onSpringContextStopped() {
        this.eventPublisher.unregister((Object)this);
    }

    public void initialise() {
        if (this.isServiceInitialised.compareAndSet(false, true)) {
            this.log.info("Initialising LexoRank Balancing Service", new Object[0]);
            this.compatibilityPluginScheduler.registerJobHandler(LexoRankBalancePluginJob.JOB_HANDLER_KEY, this.lexoRankBalancePluginJob);
            if (this.compatibilityPluginScheduler.getJobInfo(LEXO_RANK_SCHEDULER_JOB) == null) {
                this.log.info("Scheduling clustered job, jobKey=%s, JobHandlerKey=%s", LEXO_RANK_SCHEDULER_JOB, LexoRankBalancePluginJob.JOB_HANDLER_KEY);
                this.compatibilityPluginScheduler.scheduleClusteredJob(LEXO_RANK_SCHEDULER_JOB, LexoRankBalancePluginJob.JOB_HANDLER_KEY, new Date(), 60000L);
            } else {
                this.log.info("Scheduler job already present in db, not scheduling again", new Object[0]);
            }
            boolean foregroundIndexRunning = this.isForegroundReindexRunning();
            this.isBalancingDisabled.set(foregroundIndexRunning);
            this.log.info("LexoRank Balancing Service is initialised, foregroundIndexRunning=" + foregroundIndexRunning, new Object[0]);
        }
    }

    @EventListener
    public void pluginFrameworkShuttingDown(PluginFrameworkShuttingDownEvent evt) {
        this.shutdown();
    }

    @EventListener
    public void pluginModuleDisabled(PluginModuleDisabledEvent evt) {
        if (evt.getModule().getCompleteKey().equals(GH_SHUTDOWN_TRIGGER_KEY)) {
            this.shutdown();
        }
    }

    @EventListener
    public void onJiraReindexStart(ReindexAllStartedEvent event) {
        if (!event.isUsingBackgroundIndexing()) {
            this.disableBalancing();
        }
    }

    @EventListener
    public void onJiraReindexComplete(ReindexAllCompletedEvent event) {
        if (!event.isUsingBackgroundIndexing()) {
            this.enableBalancing();
        }
    }

    public boolean isBalancingDisabled() {
        return this.isBalancingDisabled.get();
    }

    public boolean shouldBalancingBackOff() {
        long backoffThreshold = this.jiraProperties.getLong(JIRA_AGILE_LEXORANK_BALANCING_BACKOFF_THRESHOLD, Long.valueOf(30000L));
        if (backoffThreshold < 0L) {
            this.log.debug("LexoRank backoff is disabled since jira.agile.lexorank.balancing.backoff.threshold property is set to negative value.", new Object[0]);
            return false;
        }
        if (this.getMaxIndexingDelayForLiveNodes() > backoffThreshold) {
            this.log.debug("For at least one node index replication is behind current node for more than threshold=%s seconds. Balancing is terminating. It will resume once index replication lag for all nodes will be within a threshold.", TimeUnit.MILLISECONDS.toSeconds(backoffThreshold));
            return true;
        }
        return false;
    }

    private long getMaxIndexingDelayForLiveNodes() {
        String currentNode = this.clusterManager.getNodeId();
        long maxDelay = 0L;
        if (currentNode != null) {
            for (Node node : this.clusterManager.findLiveNodes()) {
                if (currentNode.equals(node.getNodeId())) continue;
                maxDelay = Math.max(this.getDelayBetweenNodes(currentNode, node.getNodeId()), maxDelay);
                maxDelay = Math.max(this.getDelayBetweenNodes(node.getNodeId(), currentNode), maxDelay);
            }
        }
        return maxDelay;
    }

    private long getDelayBetweenNodes(String sendingNodeId, String receivingNodeId) {
        long now = System.currentTimeMillis();
        long currentIndexCount = this.getCurrentIndexCount(receivingNodeId, sendingNodeId);
        ReplicatedIndexOperation indexOp = this.getFirstIndexOperationAfter(sendingNodeId, currentIndexCount);
        if (indexOp != null) {
            long delay = Math.max(0L, now - indexOp.getIndexTime().getTime());
            this.log.debug("Index replication on node %s is behind node %s for %s seconds. (Based on replicated operation id: %s)", receivingNodeId, sendingNodeId, TimeUnit.MILLISECONDS.toSeconds(delay), indexOp.getId());
            return delay;
        }
        return 0L;
    }

    private long getCurrentIndexCount(String receivingNodeId, String sendingNodeId) {
        OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore = (OfBizNodeIndexCounterStore)ComponentLocator.getComponent(OfBizNodeIndexCounterStore.class);
        return ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(receivingNodeId, sendingNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicatedIndexOperation getFirstIndexOperationAfter(String sourceNodeId, Long id) {
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.EQUALS, (Object)sourceNodeId), (Object)new EntityExpr("id", EntityOperator.GREATER_THAN, (Object)id));
        EntityConditionList entityConditionList = new EntityConditionList((List)entityConditions, EntityOperator.AND);
        EntityFindOptions findOptions = new EntityFindOptions();
        findOptions.setMaxResults(1);
        try (OfBizListIterator gvs = this.ofBizDelegator.findListIteratorByCondition("ReplicatedIndexOperation", (EntityCondition)entityConditionList, null, null, (List)ImmutableList.of((Object)"indexTime"), findOptions);){
            Iterator iterator = gvs.iterator();
            if (iterator.hasNext()) {
                GenericValue gv = (GenericValue)iterator.next();
                ReplicatedIndexOperation replicatedIndexOperation = operationFactory.build(gv);
                return replicatedIndexOperation;
            }
        }
        return null;
    }

    @EventListener
    public void onLexoRankEvent(LexoRankChangeEvent event) {
        String rank = event.getNewRank();
        Long fieldId = event.getFieldId();
        this.log.debug("received LexoRankBalanceEvent fieldId=%d rank=%s", fieldId, rank);
        if (rank.length() >= 100) {
            BalancerEntry balancerEntry = new BalancerEntry.Builder(fieldId).rebalanceTimeNow().build();
            this.balancerEntryManager.save(balancerEntry);
            this.submitScheduledBalance();
        } else if (rank.length() >= 50) {
            BalancerEntry balancerEntry = new BalancerEntry.Builder(fieldId).rebalanceTime(DateTime.now().plusHours(12)).build();
            this.balancerEntryManager.save(balancerEntry);
        }
    }

    public boolean rankingOperationsDisabled(Long fieldId) {
        BalancerEntry entry = this.balancerEntryManager.get(fieldId);
        if (entry == null) {
            return false;
        }
        return entry.rankingOperationsDisabled();
    }

    public ServiceOutcome<Collection<Long>> requestFullBalance() {
        return this.scheduleBalance(this.lexoRankDao.findFieldIdsInLexoRankTable());
    }

    public ServiceOutcome<Collection<Long>> requestBalance(Long rankFieldId) {
        if (!this.lexoRankDao.findFieldIdsInLexoRankTable().contains(rankFieldId)) {
            return ServiceOutcomeImpl.error("rankFieldId", ErrorCollection.Reason.SERVER_ERROR, "gh.lexorank.balancer.error.invalid.field.id", rankFieldId);
        }
        return this.scheduleBalance(Lists.newArrayList((Object[])new Long[]{rankFieldId}));
    }

    private ServiceOutcome<Collection<Long>> scheduleBalance(Collection<Long> rankFieldIds) {
        for (Long rankFieldId : rankFieldIds) {
            BalancerEntry balancerEntry = new BalancerEntry.Builder(rankFieldId).rebalanceTimeNow().build();
            this.balancerEntryManager.save(balancerEntry);
        }
        ServiceOutcome<Void> outcome = this.submitScheduledBalance();
        if (outcome.isInvalid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(rankFieldIds);
    }

    public ServiceOutcome<Void> submitScheduledBalance() {
        if (this.isBalancingDisabled()) {
            this.log.debug("Balancing has been disabled (possibly due to foreground reindex) - rebalance not scheduled", new Object[0]);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.balancing.disabled", new Object[0]);
        }
        if (this.lexoRankSuspendManager.isSuspended()) {
            this.log.debug("Balancing has been manually disabled by an admin, and must be enabled manually - rebalance not scheduled", new Object[0]);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.balancing.suspended", new Object[0]);
        }
        if (this.shouldBalancingBackOff()) {
            this.log.debug("Balancing has been backed off because there are some nodes that are lagging behind with index recovery", new Object[0]);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.balancing.backoff", new Object[0]);
        }
        if (this.lexoRankScheduledBalanceHandler.isRunning()) {
            this.log.debug("Balance not scheduled because balance handler is already running", new Object[0]);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.balancing.in.progress", new Object[0]);
        }
        this.log.debug("Submiting balance handler task to the executor service", new Object[0]);
        this.executorService.submit(this.lexoRankScheduledBalanceHandler);
        return ServiceOutcomeImpl.ok();
    }

    @VisibleForTesting
    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    private boolean isForegroundReindexRunning() {
        TaskDescriptor liveTask = this.taskManager.getLiveTask((TaskContext)new ForegroundIndexTaskContext());
        return liveTask != null && liveTask.isStarted() && !liveTask.isFinished() && !liveTask.isCancelled();
    }

    private void shutdown() {
        if (this.isServiceInitialised.get() && this.isServiceShutdown.compareAndSet(false, true)) {
            this.log.info("LexoRank Balancing Service shutting down", new Object[0]);
            this.isBalancingDisabled.set(true);
            this.compatibilityPluginScheduler.unregisterJobHandler(LexoRankBalancePluginJob.JOB_HANDLER_KEY);
            do {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.executorService.shutdownNow();
                        if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("LexoRank executor did not terminate");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            } while (!this.executorService.isTerminated());
            this.log.info("LexoRank Balancing Service has shut down", new Object[0]);
        }
    }

    private void enableBalancing() {
        if (this.isServiceInitialised.get() && !this.isServiceShutdown.get() && this.isBalancingDisabled.compareAndSet(true, false)) {
            this.log.info("Balancing Enabled", new Object[0]);
        }
    }

    private void disableBalancing() {
        if (this.isServiceInitialised.get() && !this.isServiceShutdown.get() && this.isBalancingDisabled.compareAndSet(false, true)) {
            this.log.info("Balancing Disabled", new Object[0]);
        }
    }

    public LexoRankBalancingServiceStatus getBalanceStatus() {
        return new LexoRankBalancingServiceStatus(this.isBalancingDisabled(), this.lexoRankSuspendManager.isSuspended(), this.lexoRankScheduledBalanceHandler.isRunning());
    }

    public static class LexoRankBalancingServiceStatus {
        public final Boolean balancingDisabled;
        public final Boolean balancingSuspended;
        public final Boolean balanceHandlerRunning;

        public LexoRankBalancingServiceStatus(boolean balancingDisabled, boolean balancingSuspended, boolean balanceHandlerRunning) {
            this.balancingDisabled = balancingDisabled;
            this.balancingSuspended = balancingSuspended;
            this.balanceHandlerRunning = balanceHandlerRunning;
        }
    }

    private class LexoRankExecutor
    extends ThreadPoolExecutor {
        public LexoRankExecutor() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("lexorank-executor-thread-%d").build());
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t == null && r instanceof Future) {
                try {
                    Future future = (Future)((Object)r);
                    if (future.isDone()) {
                        future.get();
                    }
                }
                catch (CancellationException ce) {
                    t = ce;
                }
                catch (ExecutionException ee) {
                    t = ee.getCause();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (t != null) {
                LexoRankBalancingService.this.log.exception(t);
            }
        }
    }
}

