/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.global.PerformanceLogger;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.suspend.LexoRankSuspendManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.lexorank.LexoRankDeleteOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalanceChange;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalanceOperation;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalanceRankInfoService;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancerProgressLogger;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancerProgressLoggerFactory;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancingService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankBalancer {
    private static final int LAZY_INDEX_QUEUE_LIMIT = 64;
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private LexoRankDao lexoRankDao;
    @Autowired
    private IssueIndexService issueIndexService;
    @Autowired
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    @Autowired
    private ClusterLockService lockService;
    @Autowired
    private LexoRankBalancingService lexoRankBalancingService;
    @Autowired
    private LexoRankBalanceRankInfoService lexoRankBalanceRankInfoService;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private LexoRankBalancerProgressLoggerFactory lexoRankBalancerProgressLoggerFactory;
    @Autowired
    private LexoRankSuspendManager lexoRankSuspendManager;

    public ServiceResult fullBalance() {
        this.log.debug("LexoRankBalancer.fullBalance()", new Object[0]);
        Collection<Long> fieldIds = this.lexoRankDao.findFieldIdsInLexoRankTable();
        ServiceResult result = this.balanceFieldIds(fieldIds);
        this.log.debug("LexoRankBalancer.fullBalance() returning " + ToStringBuilder.reflectionToString((Object)result), new Object[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResult balanceFieldIds(Collection<Long> fieldIds) {
        Lock lock = this.getLock();
        ErrorCollection errors = new ErrorCollection();
        this.log.debug("Locking lexorank balance with lock=" + lock, new Object[0]);
        if (lock.tryLock()) {
            this.log.info("Balancing %d fields", fieldIds.size());
            try {
                for (Long fieldId : fieldIds) {
                    this.log.debug("Balancing field with id[%d]", fieldId);
                    PerformanceLogger.debug("Balancing field with id %d", fieldId).measure(() -> {
                        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.REBALANCE_FIELDID);
                        ServiceResult balanceOutcome = this.balanceFieldId(fieldId);
                        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.REBALANCE_FIELDID);
                        if (balanceOutcome.isInvalid()) {
                            errors.addAllErrors(balanceOutcome.getErrors());
                        }
                    });
                }
            }
            finally {
                lock.unlock();
                this.log.debug("Unlocking lexorank balance lock=" + lock, new Object[0]);
            }
            this.log.info("Balancing of %d fields completed with %d errors", fieldIds.size(), errors.getErrors().size());
        } else {
            this.log.warn("Failed to aquire cluster lock - balancing already in progress on another node", new Object[0]);
            errors.addError(ErrorCollection.Reason.CONFLICT, "gh.lexorank.balancer.error.in.progress", new Object[0]);
        }
        return ServiceResultImpl.from(errors);
    }

    private boolean isClusterLockAcquired() {
        Lock lock = this.getLock();
        try {
            if (lock.tryLock(0L, TimeUnit.SECONDS)) {
                lock.unlock();
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public LexoRankBalancerStatus getBalanceStatus(List<CustomField> rankFields) {
        ArrayList perFieldStatus = Lists.newArrayList();
        for (CustomField rankField : rankFields) {
            long numRankedIssues = 0L;
            Float percentComplete = null;
            ArrayList distribution = Lists.newArrayList();
            for (LexoRankBucket bucket : LexoRankBucket.values()) {
                long issueRanksInBucket = this.lexoRankDao.getRowCountInBucket(rankField.getIdAsLong(), bucket, LexoRankRow.RankRowType.ISSUE_RANK_ROW);
                distribution.add(issueRanksInBucket);
                numRankedIssues += issueRanksInBucket;
            }
            for (LexoRankBucket bucket : LexoRankBucket.values()) {
                long ranksInNextBucket = (Long)distribution.get(bucket.next().ordinal());
                long ranksInThisBucket = (Long)distribution.get(bucket.ordinal());
                if (ranksInThisBucket <= 0L || ranksInNextBucket != 0L) continue;
                long destinationBucketCount = ranksInThisBucket;
                long sourceBucketCount = (Long)distribution.get(bucket.prev().ordinal());
                if (sourceBucketCount + destinationBucketCount > 0L) {
                    percentComplete = Float.valueOf((float)destinationBucketCount * 100.0f / (float)(sourceBucketCount + destinationBucketCount));
                    percentComplete = Float.valueOf((float)Math.round(percentComplete.floatValue() * 100.0f) / 100.0f);
                    continue;
                }
                percentComplete = Float.valueOf(100.0f);
            }
            perFieldStatus.add(new LexoRankBalancerFieldStatus(rankField.getFieldName(), rankField.getIdAsLong(), numRankedIssues, percentComplete, distribution, this.lexoRankBalanceRankInfoService.getMaxRank(rankField.getIdAsLong())));
        }
        return new LexoRankBalancerStatus(this.isClusterLockAcquired(), perFieldStatus);
    }

    private Lock getLock() {
        return this.lockService.getLockForName(LexoRankBalancer.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResult balanceFieldId(long rankFieldId) {
        LexoRankBalancerProgressLogger lexoRankBalancerProgressLogger;
        LexoRankRow minimumMarkerRow = this.lexoRankDao.getMinimumMarkerRow(rankFieldId);
        LexoRankRow maximumMarkerRow = this.lexoRankDao.getMaximumMarkerRow(rankFieldId);
        LexoRank minRank = LexoRank.parse(minimumMarkerRow.getRank());
        LexoRank maxRank = LexoRank.parse(maximumMarkerRow.getRank());
        LexoRank baseMarkerRank = null;
        LexoRankBucket nextBucket = null;
        long numRowsForField = this.lexoRankDao.getRowCountForFieldId(rankFieldId).intValue();
        if (minRank.getBucket().equals((Object)maxRank.getBucket())) {
            lexoRankBalancerProgressLogger = this.lexoRankBalancerProgressLoggerFactory.create(rankFieldId, numRowsForField, 0L);
            this.log.debug("Moving marker row to start of rebalancing", new Object[0]);
            LexoRankBucket minRankBucket = minRank.getBucket();
            switch (minRankBucket) {
                case BUCKET_0: 
                case BUCKET_1: {
                    this.log.debug("Moving maximum marker row to next bucket", new Object[0]);
                    LexoRankBalanceOperation balanceOperation = LexoRankBalanceOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).balanceField(rankFieldId).moveMaximumMarkerRow().moveToBucket(maxRank.getBucket().next()).build();
                    LexoRankOperationOutcome<LexoRankBalanceChange> balanceOperationOutcome = balanceOperation.execute();
                    if (!balanceOperationOutcome.isValid()) {
                        return ServiceResultImpl.from(balanceOperationOutcome.getErrors());
                    }
                    lexoRankBalancerProgressLogger.makeProgress();
                    LexoRankBalanceChange balanceChange = balanceOperationOutcome.getResult();
                    maxRank = balanceChange.getNewRank();
                    nextBucket = balanceChange.getNewBucket();
                    baseMarkerRank = maxRank;
                    break;
                }
                case BUCKET_2: {
                    this.log.debug("Moving minimum marker row from bucket 2 to bucket 0", new Object[0]);
                    LexoRankBalanceOperation balanceOperation = LexoRankBalanceOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).balanceField(rankFieldId).moveMinimumMarkerRow().moveToBucket(maxRank.getBucket().next()).build();
                    LexoRankOperationOutcome<LexoRankBalanceChange> balanceOperationOutcome = balanceOperation.execute();
                    if (!balanceOperationOutcome.isValid()) {
                        return ServiceResultImpl.from(balanceOperationOutcome.getErrors());
                    }
                    lexoRankBalancerProgressLogger.makeProgress();
                    LexoRankBalanceChange balanceChange = balanceOperationOutcome.getResult();
                    minRank = balanceChange.getNewRank();
                    nextBucket = balanceChange.getNewBucket();
                    baseMarkerRank = minRank;
                    break;
                }
                default: {
                    return ServiceResultImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.lexorank.balancer.error.nobucket", new Object[]{minRankBucket});
                }
            }
        } else {
            LexoRankBucket minimumMarkerBucket = minRank.getBucket();
            LexoRankBucket maximumMarkerBucket = maxRank.getBucket();
            if (minimumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_0) && maximumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_2)) {
                nextBucket = LexoRankBucket.BUCKET_0;
                baseMarkerRank = minRank;
            } else if (minimumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_0) && maximumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_1)) {
                nextBucket = LexoRankBucket.BUCKET_1;
                baseMarkerRank = maxRank;
            } else if (minimumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_1) && maximumMarkerBucket.equals((Object)LexoRankBucket.BUCKET_2)) {
                nextBucket = LexoRankBucket.BUCKET_2;
                baseMarkerRank = maxRank;
            }
            long numRowsBalanced = this.lexoRankDao.getRowCountInBucket(rankFieldId, nextBucket);
            lexoRankBalancerProgressLogger = this.lexoRankBalancerProgressLoggerFactory.create(rankFieldId, numRowsForField, numRowsBalanced);
        }
        if (!this.verifyMarkerRanksInBalanceableState(minRank, maxRank)) {
            this.log.debug("The rank rows for rank field [id=%s] are not in a balanceable state", rankFieldId);
            return ServiceResultImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.lexorank.balancer.error.nocombination", new Object[]{minRank.getBucket(), maxRank.getBucket()});
        }
        LinkedBlockingQueue<Issue> indexingQueue = new LinkedBlockingQueue<Issue>(64);
        ExecutorService indexer = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"LexoRankReindexer"));
        try {
            ServiceResult balancingStaus;
            indexer.submit(new IndexingRunnable(indexingQueue, indexer));
            while ((balancingStaus = this.getBalancingStatus(indexer, rankFieldId)).isValid()) {
                this.log.debug("Balancing next rank row for rank field [id=%s]", rankFieldId);
                LexoRankBalanceOperation balanceOperation = LexoRankBalanceOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).balanceField(rankFieldId).moveNextRankRow().moveToBucket(nextBucket).build();
                LexoRankOperationOutcome<LexoRankBalanceChange> balanceOperationOutcome = balanceOperation.execute();
                if (!balanceOperationOutcome.isValid()) {
                    ServiceResult serviceResult = ServiceResultImpl.from(balanceOperationOutcome.getErrors());
                    return serviceResult;
                }
                lexoRankBalancerProgressLogger.makeProgress();
                LexoRankBalanceChange balanceChange = balanceOperationOutcome.getResult();
                Long issueId = balanceChange.getIssueId();
                if (issueId != null && !balanceChange.isVirtualIssue()) {
                    MutableIssue issue = this.issueManager.getIssueObject(issueId);
                    if (issue == null) {
                        this.log.debug("Detected a rank for an issue that doesn't exist. Deleting all ranks for issue[id=%s]", issueId);
                        this.deleteRanksForIssue(issueId);
                    } else {
                        this.log.debug("ReIndexing issue[id=%s]", issueId);
                        try {
                            indexingQueue.put((Issue)issue);
                        }
                        catch (InterruptedException e) {
                            this.log.error("Unable to reindex rank for issue - " + issue.getKey(), new Object[0]);
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (!this.checkIfComplete(balanceChange.getNewRank(), baseMarkerRank)) continue;
                this.log.debug("Balancing of rank rows for rank field [id=%s] is complete", rankFieldId);
                balancingStaus = ServiceResultImpl.ok();
                break;
            }
            this.shutDownIndexer(indexer);
            ServiceResult serviceResult = balancingStaus;
            return serviceResult;
        }
        finally {
            indexer.shutdownNow();
        }
    }

    private ServiceResult getBalancingStatus(ExecutorService indexer, long rankFieldId) {
        if (this.lexoRankBalancingService.isBalancingDisabled() || indexer.isShutdown()) {
            this.log.debug("Balancing for rank field [id=%s] is terminating", rankFieldId);
            return ServiceResultImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.lexorank.balancer.error.plugin.terminating", new Object[0]);
        }
        if (this.lexoRankBalancingService.shouldBalancingBackOff()) {
            this.log.debug("Balancing for rank field [id=%s] is terminating - backoff", rankFieldId);
            return ServiceResultImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.lexorank.service.error.balancing.backoff", new Object[0]);
        }
        if (this.lexoRankSuspendManager.isSuspended()) {
            this.log.debug("Balancing for rank field [id=%s] is terminating - suspended by user", rankFieldId);
            return ServiceResultImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.balancer.error.suspended", new Object[0]);
        }
        return ServiceResultImpl.ok();
    }

    private void shutDownIndexer(ExecutorService indexer) {
        indexer.shutdown();
        try {
            if (!indexer.awaitTermination(320L, TimeUnit.SECONDS)) {
                indexer.shutdownNow();
                if (!indexer.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.log.error("Indexing executor for LexoRank balance did not terminate.", new Object[0]);
                }
            }
        }
        catch (InterruptedException e1) {
            this.log.error("LexoRank indexing termination was interrupted.", new Object[0]);
        }
    }

    private void deleteRanksForIssue(Long issueId) {
        LexoRankDeleteOperation deleteOperation = LexoRankDeleteOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).forIssue(issueId).build();
        deleteOperation.execute();
    }

    private boolean verifyMarkerRanksInBalanceableState(LexoRank minRank, LexoRank maxRank) {
        LexoRankBucket minRankBucket = minRank.getBucket();
        LexoRankBucket maxRankBucket = maxRank.getBucket();
        if (minRankBucket.equals((Object)LexoRankBucket.BUCKET_0) && maxRankBucket.equals((Object)LexoRankBucket.BUCKET_1)) {
            return true;
        }
        if (minRankBucket.equals((Object)LexoRankBucket.BUCKET_1) && maxRankBucket.equals((Object)LexoRankBucket.BUCKET_2)) {
            return true;
        }
        return minRankBucket.equals((Object)LexoRankBucket.BUCKET_0) && maxRankBucket.equals((Object)LexoRankBucket.BUCKET_2);
    }

    private boolean checkIfComplete(LexoRank rank, LexoRank baseRank) {
        return baseRank.isMin() && rank.isMax() || baseRank.isMax() && rank.isMin();
    }

    private class IndexingRunnable
    implements Runnable {
        private final BlockingQueue<Issue> indexingQueue;
        private final ExecutorService indexer;

        public IndexingRunnable(BlockingQueue<Issue> indexingQueue, ExecutorService indexer) {
            this.indexingQueue = indexingQueue;
            this.indexer = indexer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.indexer.isShutdown() || !this.indexingQueue.isEmpty()) {
                if (LexoRankBalancer.this.lexoRankBalancingService.isBalancingDisabled()) {
                    LexoRankBalancer.this.log.warn("Balancing disabled while balance indexing was in progress. All issues may not be properly indexed.", new Object[0]);
                    break;
                }
                ArrayList<Issue> issuesToIndex = new ArrayList<Issue>();
                Issue issue = null;
                try {
                    issue = this.indexingQueue.poll(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LexoRankBalancer.this.log.error("Indexing for LexoRank re-balancing was interrupted.", new Object[0]);
                }
                if (issue == null) continue;
                issuesToIndex.add(issue);
                this.indexingQueue.drainTo(issuesToIndex);
                IssueIndexingParams params = IssueIndexingParams.builder().setComments(false).setChangeHistory(false).build();
                try {
                    JiraThreadLocalUtils.preCall();
                    ServiceOutcome<Void> outcome = LexoRankBalancer.this.issueIndexService.reindexIssueAndSubtasks(issuesToIndex, params);
                    if (outcome.isValid()) continue;
                    LexoRankBalancer.this.log.error("Indexing failed, will abort indexing any more issues in the balancer", new Object[0]);
                    LexoRankBalancer.this.log.error(ErrorCollection.fromJiraErrorCollection(outcome.getErrorCollection()));
                    break;
                }
                finally {
                    JiraThreadLocalUtils.postCall();
                }
            }
            this.indexer.shutdown();
            this.indexingQueue.clear();
        }
    }

    public static class LexoRankBalancerFieldStatus {
        public final String fieldName;
        public final Long fieldId;
        public final Long numRankedIssues;
        public final Float percentComplete;
        public final List<Long> distribution;
        public final LexoRankBalanceRankInfoService.LexoRankMaxRank maxRank;

        LexoRankBalancerFieldStatus(String fieldName, Long fieldId, Long numRankedIssues, Float percentComplete, List<Long> distribution, LexoRankBalanceRankInfoService.LexoRankMaxRank maxRank) {
            this.fieldName = fieldName;
            this.fieldId = fieldId;
            this.numRankedIssues = numRankedIssues;
            this.percentComplete = percentComplete;
            this.distribution = distribution;
            this.maxRank = maxRank;
        }
    }

    public static class LexoRankBalancerStatus {
        public final Boolean balancerLocked;
        public final List<LexoRankBalancerFieldStatus> perFieldStatus;

        public LexoRankBalancerStatus(Boolean balancerLocked, List<LexoRankBalancerFieldStatus> perFieldStatus) {
            this.balancerLocked = balancerLocked;
            this.perFieldStatus = perFieldStatus;
        }
    }
}

