/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankBalanceRankInfoService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private LexoRankDao lexoRankDao;
    @Autowired
    private IssueManager issueManager;

    private LexoRankRebalanceOperation getNextRebalanceOperation(LexoRankRow maxRank) {
        int rankLength = maxRank.getRank().length();
        if (rankLength < 50) {
            return new LexoRankRebalanceOperation(false, 50, RebalanceDangerRating.OK);
        }
        return new LexoRankRebalanceOperation(true, 100, RebalanceDangerRating.WARNING);
    }

    private String getIssueKey(Long issueId) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            return issue.getKey();
        }
        catch (DataAccessException e) {
            this.log.warn("Error while retrieving issue with ID %d", issueId);
            this.log.exception(e);
            return "";
        }
    }

    public LexoRankMaxRank getMaxRank(Long fieldId) {
        Option<LexoRankRow> maybeMaximumRankLengthRow = this.lexoRankDao.findMaximumRankLengthRow(fieldId);
        if (maybeMaximumRankLengthRow.isEmpty()) {
            return LexoRankMaxRank.empty();
        }
        LexoRankRow maxRank = (LexoRankRow)maybeMaximumRankLengthRow.get();
        LexoRankRebalanceOperation nextRebalanceOperation = this.getNextRebalanceOperation(maxRank);
        String issueKey = this.getIssueKey(maxRank.getIssueId());
        return new LexoRankMaxRank(maxRank.getRank().length(), nextRebalanceOperation, issueKey);
    }

    public static class LexoRankRebalanceOperation {
        public final boolean isImmediate;
        public final int limit;
        public final String status;

        public LexoRankRebalanceOperation(boolean isImmediate, int limit, RebalanceDangerRating status) {
            this.isImmediate = isImmediate;
            this.limit = limit;
            this.status = status.name();
        }

        public static LexoRankRebalanceOperation empty() {
            return new LexoRankRebalanceOperation(false, 50, RebalanceDangerRating.OK);
        }
    }

    public static class LexoRankMaxRank {
        public final int rankLength;
        public final int maxLength;
        public final LexoRankRebalanceOperation nextRebalance;
        public final String issueKey;

        public LexoRankMaxRank(int rankLength, LexoRankRebalanceOperation nextRebalance, String issueKey) {
            this.rankLength = rankLength;
            this.maxLength = 254;
            this.nextRebalance = nextRebalance;
            this.issueKey = issueKey;
        }

        public static LexoRankMaxRank empty() {
            return new LexoRankMaxRank(0, LexoRankRebalanceOperation.empty(), "");
        }
    }

    private static enum RebalanceDangerRating {
        WARNING,
        OK;

    }
}

