/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRowUtils;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.BackoffHandler;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankSettings;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalanceChange;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;

public class LexoRankBalanceOperation {
    private static final LoggerWrapper LOG = LoggerWrapper.with(LexoRankBalanceOperation.class);
    private static final Map<BalanceOperationType, LexoRankStatisticsAgent.Operation> balanceOperationToLexoOperationMap = Maps.newHashMap();
    private final LexoRankDao dao;
    private final LexoRankStatisticsAgent statisticsAgent;
    private final Long rankFieldId;
    private final BalanceOperationType balanceOperationType;
    private final LexoRankBucket newBucket;

    private LexoRankBalanceOperation(LexoRankDao dao, LexoRankStatisticsAgent statisticsAgent, Long rankFieldId, BalanceOperationType balanceOperationType, LexoRankBucket bucket) {
        this.dao = dao;
        this.statisticsAgent = statisticsAgent;
        this.rankFieldId = rankFieldId;
        this.balanceOperationType = balanceOperationType;
        this.newBucket = bucket;
    }

    public static FieldToBalance builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
        return new Builder(lexoRankDao, lexoRankStatisticsAgent);
    }

    public LexoRankOperationOutcome<LexoRankBalanceChange> execute() {
        this.logStartOfOperation();
        LexoRankOperationOutcome<LexoRankBalanceChange> operationOutcome = null;
        switch (this.balanceOperationType) {
            case MOVE_MAX: 
            case MOVE_MIN: {
                operationOutcome = this.moveMarkerRowToNextBucket();
                break;
            }
            case MOVE_NEXT: {
                operationOutcome = this.moveNextRowToNextBucket();
            }
        }
        this.logEndOfOperation();
        return operationOutcome;
    }

    private void logStartOfOperation() {
        this.statisticsAgent.startOperation(balanceOperationToLexoOperationMap.get((Object)this.balanceOperationType));
    }

    private void logEndOfOperation() {
        this.statisticsAgent.endOperation(balanceOperationToLexoOperationMap.get((Object)this.balanceOperationType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LexoRankOperationOutcome<LexoRankBalanceChange> moveNextRowToNextBucket() {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.BALANCE_RETRY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.statisticsAgent, timeoutTime);
        LexoRankBucket oldBucket = this.newBucket.prev();
        LOG.debug("Balancing next rank row to migrate from bucket[%s] to bucket[%s] for rank field[id=%s]", oldBucket.format(), this.newBucket.format(), this.rankFieldId);
        while (true) {
            if (System.currentTimeMillis() >= timeoutTime) {
                LOG.debug("balance operation timed out", new Object[0]);
                return LexoRankOperationOutcome.timeout();
            }
            backoffHandler.maybeWait();
            LexoRankRow[] rowsAtBalanceBoundary = this.dao.getRowsAtBalanceBoundaryForFieldId(this.rankFieldId, oldBucket, this.newBucket);
            LOG.debug("Fetched rows at balance boundary", new Object[0]);
            if (rowsAtBalanceBoundary.length != 2) {
                LOG.debug("Couldn't find the balance boundary rows. Got %s rows", rowsAtBalanceBoundary.length);
                return LexoRankOperationOutcome.error(ErrorCollection.Reason.SERVER_ERROR, "Couldn't find rows on balance boundary", new Object[0]);
            }
            LOG.debug("Fetched rows at balance boundary", new Object[0]);
            LOG.debug("\trowToMigrate : %s", rowsAtBalanceBoundary[0]);
            LOG.debug("\trowLastMigrated : %s", rowsAtBalanceBoundary[1]);
            LexoRankRow rowToBeMigrated = rowsAtBalanceBoundary[0];
            LexoRankRow rowLastMigrated = rowsAtBalanceBoundary[1];
            LexoRank rankToBeMigrated = LexoRank.parse(rowToBeMigrated.getRank());
            LexoRank rankLastMigrated = LexoRank.parse(rowLastMigrated.getRank());
            if (!rankToBeMigrated.getBucket().equals((Object)oldBucket)) {
                LOG.error("Expected the row to migrate to be in the old bucket [oldBucket=%s, rowBucket=%s]", oldBucket.format(), rankToBeMigrated.getBucket().format());
                return LexoRankOperationOutcome.error(ErrorCollection.Reason.SERVER_ERROR, "Expected the row to migrate to be in the old bucket", new Object[0]);
            }
            if (!rankLastMigrated.getBucket().equals((Object)this.newBucket)) {
                LOG.error("Expected the row last migrated to be in the new bucket [newBucket=%s, rowBucket=%s]", this.newBucket.format(), rankLastMigrated.getBucket().format());
                return LexoRankOperationOutcome.error(ErrorCollection.Reason.SERVER_ERROR, "Expected the row last migrated to be in the new bucket", new Object[0]);
            }
            LockOutcome lockOutcome = this.dao.acquireLock(rowsAtBalanceBoundary);
            if (lockOutcome.isInvalid()) {
                if (!lockOutcome.isFailRetry()) {
                    LOG.debug("Failed to acquire lock on rows [reason=%s], not recoverable", lockOutcome.getFailDetails());
                    return LexoRankOperationOutcome.error(ErrorCollection.Reason.SERVER_ERROR, lockOutcome.getFailDetails(), new Object[0]);
                }
                LOG.debug("Failed to acquire lock on rows [reason=%s], trying to again", lockOutcome.getFailDetails());
                continue;
            }
            Lock lock = lockOutcome.get();
            try {
                LexoRank oldRank;
                LOG.debug("Acquired lock on rows", new Object[0]);
                LexoRankRow[] lockedRowsAtBalanceBoundary = this.dao.getRowsAtBalanceBoundaryForFieldId(this.rankFieldId, oldBucket, this.newBucket);
                if (lockedRowsAtBalanceBoundary.length != 2) {
                    LOG.debug("Couldn't find the balance boundary rows. Got %s rows", rowsAtBalanceBoundary.length);
                    LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.error(ErrorCollection.Reason.SERVER_ERROR, "Couldn't find rows on balance boundary", new Object[0]);
                    return lexoRankOperationOutcome;
                }
                if (LexoRankRowUtils.areRowsDifferent(rowsAtBalanceBoundary, lockedRowsAtBalanceBoundary)) {
                    LOG.debug("Rows at the balance boundary have changed since we acquired the lock, retry", new Object[0]);
                    continue;
                }
                LexoRank newRank = null;
                switch (rowToBeMigrated.getType()) {
                    case MAXIMUM_MARKER_ROW: 
                    case MINIMUM_MARKER_ROW: {
                        oldRank = LexoRank.parse(rowToBeMigrated.getRank());
                        newRank = oldRank.inNextBucket();
                        break;
                    }
                    case ISSUE_RANK_ROW: {
                        LexoRank rankOfLastRowMigrated = LexoRank.parse(rowLastMigrated.getRank());
                        newRank = this.getNewRankForRowToBeMigrated(oldBucket, rankOfLastRowMigrated);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown rank row type");
                    }
                }
                oldRank = LexoRank.parse(rowToBeMigrated.getRank());
                LOG.debug("Balancing rank row [type=%s, oldRank=%s, newRank=%s]", rowToBeMigrated.getType().name(), oldRank.format(), newRank.format());
                rowToBeMigrated.setRank(newRank.format());
                boolean existsRankForFieldId = this.dao.existsRankForFieldId(this.rankFieldId, rowToBeMigrated.getRank());
                if (existsRankForFieldId) {
                    LOG.debug("New rank[%s] for issue[id=%s] for rank field[id=%s] already exists, retrying balance oepration", newRank.format(), rowToBeMigrated.getIssueId(), this.rankFieldId);
                    continue;
                }
                LockProcessOutcome<ServiceOutcome<LexoRankRow>> lockedSaveOutcome = this.dao.save(lock, rowToBeMigrated);
                if (lockedSaveOutcome.isRetry()) {
                    LOG.debug("Failed to save rank row, retry", new Object[0]);
                    continue;
                }
                ServiceOutcome<LexoRankRow> moveOutcome = lockedSaveOutcome.get();
                if (moveOutcome.isInvalid()) {
                    LOG.debug("Failed to save rank row, aborting", new Object[0]);
                    LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.error(moveOutcome.getErrors());
                    return lexoRankOperationOutcome;
                }
                LOG.debug("Successfully saved rank row", new Object[0]);
                switch (rowToBeMigrated.getType()) {
                    case ISSUE_RANK_ROW: {
                        Long issueId = rowToBeMigrated.getIssueId();
                        LexoRankBalanceChange balanceChange = LexoRankBalanceChange.builder().forRankField(this.rankFieldId).movedIssueRow().forIssue(issueId).movedFromBucket(oldBucket).movedToBucket(this.newBucket).changedRankFrom(oldRank).changedRankTo(newRank).build();
                        LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(balanceChange, issueId);
                        return lexoRankOperationOutcome;
                    }
                    case MINIMUM_MARKER_ROW: {
                        LexoRankBalanceChange balanceChange = LexoRankBalanceChange.builder().forRankField(this.rankFieldId).movedMinimumMarkerRow().movedFromBucket(oldBucket).movedToBucket(this.newBucket).changedRankFrom(oldRank).changedRankTo(newRank).build();
                        LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(balanceChange);
                        return lexoRankOperationOutcome;
                    }
                    case MAXIMUM_MARKER_ROW: {
                        LexoRankBalanceChange balanceChange = LexoRankBalanceChange.builder().forRankField(this.rankFieldId).movedMinimumMarkerRow().movedFromBucket(oldBucket).movedToBucket(this.newBucket).changedRankFrom(oldRank).changedRankTo(newRank).build();
                        LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(balanceChange);
                        return lexoRankOperationOutcome;
                    }
                }
                continue;
            }
            finally {
                LOG.debug("Releasing lock", new Object[0]);
                this.dao.releaseLock(lock);
                continue;
            }
            break;
        }
    }

    private LexoRank getNewRankForRowToBeMigrated(LexoRankBucket oldBucket, LexoRank rankOfLastRowMigrated) {
        LexoRank newRank;
        if (rankOfLastRowMigrated.isMin() || rankOfLastRowMigrated.isMax()) {
            newRank = LexoRank.from(this.newBucket, LexoRank.MID_DECIMAL);
        } else {
            boolean migrationOrderIsSmallToLarge = oldBucket.compareTo(this.newBucket) > 0;
            newRank = migrationOrderIsSmallToLarge ? rankOfLastRowMigrated.genNext() : rankOfLastRowMigrated.genPrev();
        }
        return newRank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<LexoRankBalanceChange> moveMarkerRowToNextBucket() {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.BALANCE_RETRY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.statisticsAgent, timeoutTime);
        while (System.currentTimeMillis() < timeoutTime) {
            backoffHandler.maybeWait();
            LexoRankRow[] unlockedRankRows = this.balanceOperationType.equals((Object)BalanceOperationType.MOVE_MAX) ? this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId) : this.dao.getMinimumMarkerRowAndNextRow(this.rankFieldId);
            HashSet rowsToLock = Sets.newHashSet((Object[])new LexoRankRow[]{unlockedRankRows[0], unlockedRankRows[1]});
            LockOutcome lockOutcome = this.dao.acquireLock(rowsToLock);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock == null) continue;
                this.dao.releaseLock(lock);
                continue;
            }
            try {
                LexoRankRow[] lockedRankRows = this.balanceOperationType.equals((Object)BalanceOperationType.MOVE_MAX) ? this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId) : this.dao.getMinimumMarkerRowAndNextRow(this.rankFieldId);
                if (LexoRankRowUtils.areRowsDifferent(lockedRankRows, unlockedRankRows)) continue;
                LexoRankRow markerRowToMigrate = lockedRankRows[0];
                LexoRank oldRank = LexoRank.parse(markerRowToMigrate.getRank());
                LexoRank newRank = oldRank.inNextBucket();
                if (!newRank.getBucket().equals((Object)this.newBucket)) {
                    throw new IllegalStateException("The new rank's bucket is not the same as the expected next bucket");
                }
                markerRowToMigrate.setRank(newRank.format());
                boolean existsRankForFieldId = this.dao.existsRankForFieldId(this.rankFieldId, markerRowToMigrate.getRank());
                if (existsRankForFieldId) {
                    LOG.debug("New rank[%s] for marker row for rank field[id=%s] already exists, retrying balance oepration", newRank.format(), this.rankFieldId);
                    continue;
                }
                LockProcessOutcome<ServiceOutcome<LexoRankRow>> saveResult = this.dao.save(lock, markerRowToMigrate);
                if (saveResult.isRetry()) continue;
                LexoRankBalanceChange balanceChange = LexoRankBalanceChange.builder().forRankField(this.rankFieldId).moveMarkerRow(this.balanceOperationType).movedFromBucket(oldRank.getBucket()).movedToBucket(this.newBucket).changedRankFrom(oldRank).changedRankTo(newRank).build();
                LexoRankOperationOutcome<LexoRankBalanceChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(balanceChange);
                return lexoRankOperationOutcome;
            }
            finally {
                this.dao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    static {
        balanceOperationToLexoOperationMap.put(BalanceOperationType.MOVE_MAX, LexoRankStatisticsAgent.Operation.MAX_TO_NEXT_BUCKET);
        balanceOperationToLexoOperationMap.put(BalanceOperationType.MOVE_MIN, LexoRankStatisticsAgent.Operation.MIN_TO_NEXT_BUCKET);
    }

    public static interface CompleteBalanceOperation {
        public LexoRankBalanceOperation build();
    }

    public static interface BucketToMigrateTo {
        public CompleteBalanceOperation moveToBucket(LexoRankBucket var1);
    }

    public static interface TypeOfBalanceOperation {
        public BucketToMigrateTo moveMaximumMarkerRow();

        public BucketToMigrateTo moveMinimumMarkerRow();

        public BucketToMigrateTo moveNextRankRow();
    }

    public static interface FieldToBalance {
        public TypeOfBalanceOperation balanceField(Long var1);
    }

    private static class Builder
    implements FieldToBalance,
    TypeOfBalanceOperation,
    BucketToMigrateTo,
    CompleteBalanceOperation {
        private LexoRankDao lexoRankDao;
        private LexoRankStatisticsAgent lexoRankStatisticsAgent;
        private BalanceOperationType balanceOperationType;
        private Long rankFieldId;
        private LexoRankBucket newBucket;

        private Builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
            this.lexoRankDao = lexoRankDao;
            this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        }

        @Override
        public LexoRankBalanceOperation build() {
            return new LexoRankBalanceOperation(this.lexoRankDao, this.lexoRankStatisticsAgent, this.rankFieldId, this.balanceOperationType, this.newBucket);
        }

        @Override
        public TypeOfBalanceOperation balanceField(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        @Override
        public BucketToMigrateTo moveMaximumMarkerRow() {
            this.balanceOperationType = BalanceOperationType.MOVE_MAX;
            return this;
        }

        @Override
        public BucketToMigrateTo moveMinimumMarkerRow() {
            this.balanceOperationType = BalanceOperationType.MOVE_MIN;
            return this;
        }

        @Override
        public CompleteBalanceOperation moveToBucket(LexoRankBucket bucket) {
            this.newBucket = bucket;
            return this;
        }

        @Override
        public BucketToMigrateTo moveNextRankRow() {
            this.balanceOperationType = BalanceOperationType.MOVE_NEXT;
            return this;
        }
    }

    public static enum BalanceOperationType {
        MOVE_MAX,
        MOVE_MIN,
        MOVE_NEXT;

    }
}

