/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank.balance;

import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalanceOperation;

public class LexoRankBalanceChange {
    private final LexoRankBalanceOperation.BalanceOperationType operationType;
    private final Long rankFieldId;
    private final Long issueId;
    private final LexoRankBucket oldBucket;
    private final LexoRankBucket newBucket;
    private final LexoRank oldRank;
    private final LexoRank newRank;

    private LexoRankBalanceChange(Long rankFieldId, LexoRankBalanceOperation.BalanceOperationType operationType, Long issueId, LexoRankBucket oldBucket, LexoRankBucket newBucket, LexoRank oldRank, LexoRank newRank) {
        this.rankFieldId = rankFieldId;
        this.operationType = operationType;
        this.issueId = issueId;
        this.oldBucket = oldBucket;
        this.newBucket = newBucket;
        this.oldRank = oldRank;
        this.newRank = newRank;
    }

    public static ForRankField builder() {
        return new Builder();
    }

    public LexoRankBalanceOperation.BalanceOperationType getOperationType() {
        return this.operationType;
    }

    public Long getRankFieldId() {
        return this.rankFieldId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public boolean isVirtualIssue() {
        return this.issueId != null && this.issueId < 0L;
    }

    public LexoRankBucket getOldBucket() {
        return this.oldBucket;
    }

    public LexoRankBucket getNewBucket() {
        return this.newBucket;
    }

    public LexoRank getOldRank() {
        return this.oldRank;
    }

    public LexoRank getNewRank() {
        return this.newRank;
    }

    public static interface CompleteBalanceChangeEvent {
        public LexoRankBalanceChange build();
    }

    public static interface ChangedRankTo {
        public CompleteBalanceChangeEvent changedRankTo(LexoRank var1);
    }

    public static interface ChangedRankFrom {
        public ChangedRankTo changedRankFrom(LexoRank var1);
    }

    public static interface MovedToBucket {
        public ChangedRankFrom movedToBucket(LexoRankBucket var1);
    }

    public static interface MovedFromBucket {
        public MovedToBucket movedFromBucket(LexoRankBucket var1);
    }

    public static interface ForIssue {
        public MovedFromBucket forIssue(Long var1);
    }

    public static interface PerformedBalanceOperation {
        public MovedFromBucket moveMarkerRow(LexoRankBalanceOperation.BalanceOperationType var1);

        public MovedFromBucket movedMaximumMarkerRow();

        public MovedFromBucket movedMinimumMarkerRow();

        public ForIssue movedIssueRow();
    }

    public static interface ForRankField {
        public PerformedBalanceOperation forRankField(Long var1);
    }

    private static class Builder
    implements ForRankField,
    PerformedBalanceOperation,
    ForIssue,
    MovedFromBucket,
    MovedToBucket,
    ChangedRankFrom,
    ChangedRankTo,
    CompleteBalanceChangeEvent {
        private LexoRankBalanceOperation.BalanceOperationType operationType;
        private Long rankFieldId;
        private Long issueId;
        private LexoRankBucket oldBucket;
        private LexoRankBucket newBucket;
        private LexoRank oldRank;
        private LexoRank newRank;

        private Builder() {
        }

        @Override
        public ChangedRankTo changedRankFrom(LexoRank rank) {
            this.oldRank = rank;
            return this;
        }

        @Override
        public CompleteBalanceChangeEvent changedRankTo(LexoRank rank) {
            this.newRank = rank;
            return this;
        }

        @Override
        public LexoRankBalanceChange build() {
            return new LexoRankBalanceChange(this.rankFieldId, this.operationType, this.issueId, this.oldBucket, this.newBucket, this.oldRank, this.newRank);
        }

        @Override
        public MovedFromBucket forIssue(Long issueId) {
            this.issueId = issueId;
            return this;
        }

        @Override
        public PerformedBalanceOperation forRankField(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        @Override
        public MovedToBucket movedFromBucket(LexoRankBucket bucket) {
            this.oldBucket = bucket;
            return this;
        }

        @Override
        public ChangedRankFrom movedToBucket(LexoRankBucket bucket) {
            this.newBucket = bucket;
            return this;
        }

        @Override
        public MovedFromBucket movedMaximumMarkerRow() {
            this.operationType = LexoRankBalanceOperation.BalanceOperationType.MOVE_MAX;
            return this;
        }

        @Override
        public MovedFromBucket movedMinimumMarkerRow() {
            this.operationType = LexoRankBalanceOperation.BalanceOperationType.MOVE_MAX;
            return this;
        }

        @Override
        public MovedFromBucket moveMarkerRow(LexoRankBalanceOperation.BalanceOperationType operationType) {
            switch (operationType) {
                case MOVE_MAX: {
                    return this.movedMaximumMarkerRow();
                }
                case MOVE_MIN: {
                    return this.movedMinimumMarkerRow();
                }
            }
            throw new IllegalArgumentException("Only balance operation types MOVE_MAX and MOVE_MIN can be used.");
        }

        @Override
        public ForIssue movedIssueRow() {
            this.operationType = LexoRankBalanceOperation.BalanceOperationType.MOVE_NEXT;
            return this;
        }
    }
}

