/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankStatisticsAgent {
    protected static final LoggerWrapper log = LoggerWrapper.with(LexoRankStatisticsAgent.class);
    private final String LEXO_RANK_STATS_COLLECTOR_JOB = "LEXO_RANK_STATS_COLLECTOR_JOB";
    private static final String JOB_DATA_STATS_COLLECTOR_KEY = "LexoRankStatsCollector";
    @Autowired
    private PluginScheduler pluginScheduler;
    private final ConcurrentLinkedQueue<StatsEvent> statsEventQueue = new ConcurrentLinkedQueue();
    private final SystemState systemState = new SystemState();
    private ThreadLocal<Operation> lastOperation = new ThreadLocal();

    public void start() {
        HashMap<String, LexoRankStatisticsAgent> jobDataMap = new HashMap<String, LexoRankStatisticsAgent>();
        jobDataMap.put(JOB_DATA_STATS_COLLECTOR_KEY, this);
        this.pluginScheduler.scheduleJob("LEXO_RANK_STATS_COLLECTOR_JOB", CollectorJob.class, jobDataMap, new Date(), 100L);
    }

    public void stop() {
        this.pluginScheduler.unscheduleJob("LEXO_RANK_STATS_COLLECTOR_JOB");
    }

    public void startOperation(Operation operation) {
        if (log.isDebugEnabled()) {
            this.lastOperation.set(operation);
            this.statsEventQueue.add(new StatsEvent(operation, StatsEvent.EventType.START));
        }
    }

    public void startOperationStep(OperationStep operationStep) {
        if (log.isDebugEnabled() && this.lastOperation.get() != null) {
            this.statsEventQueue.add(new StatsEvent(this.lastOperation.get(), StatsEvent.EventType.START, operationStep));
        }
    }

    public void endOperation(Operation operation) {
        if (log.isDebugEnabled()) {
            this.lastOperation.remove();
            this.statsEventQueue.add(new StatsEvent(operation, StatsEvent.EventType.END));
        }
    }

    public void endOperationStep(OperationStep operationStep) {
        if (log.isDebugEnabled() && this.lastOperation.get() != null) {
            this.statsEventQueue.add(new StatsEvent(this.lastOperation.get(), StatsEvent.EventType.END, operationStep));
        }
    }

    public String generateReport() {
        StatsEvent event;
        StatisticCollector collector = new StatisticCollector();
        while ((event = this.statsEventQueue.poll()) != null) {
            this.systemState.processEvent(event, collector);
        }
        return collector.generateReport();
    }

    public static class CollectorJob
    implements PluginJob {
        public void execute(Map<String, Object> jobDataMap) {
            LexoRankStatisticsAgent lexoRankStatisticsAgent = (LexoRankStatisticsAgent)jobDataMap.get(LexoRankStatisticsAgent.JOB_DATA_STATS_COLLECTOR_KEY);
            log.debug(lexoRankStatisticsAgent.generateReport(), new Object[0]);
        }
    }

    private class SystemState {
        private final Map<Thread, Deque<StatsEvent>> threadStateMap = new HashMap<Thread, Deque<StatsEvent>>();

        private SystemState() {
        }

        public void processEvent(StatsEvent event, StatisticCollector collector) {
            Deque<StatsEvent> threadDequeue = this.threadStateMap.get(event.thread);
            if (threadDequeue == null) {
                threadDequeue = new ArrayDeque<StatsEvent>();
                this.threadStateMap.put(event.thread, threadDequeue);
            }
            if (event.eventType == StatsEvent.EventType.START) {
                threadDequeue.addLast(event);
            } else if (event.eventType == StatsEvent.EventType.END) {
                StatsEvent previousEvent;
                while ((previousEvent = threadDequeue.pollLast()) != null) {
                    if (previousEvent.operation != event.operation || previousEvent.eventType != StatsEvent.EventType.START || previousEvent.operationStep != event.operationStep) {
                        log.error("Unexpected stats event " + previousEvent + " found when searching for event matching " + event + ", skipping", new Object[0]);
                        continue;
                    }
                    collector.addStatistic(event.operation, event.time - previousEvent.time, event.operationStep);
                    break;
                }
                if (previousEvent == null) {
                    log.error("Could not find a matching start event for " + event, new Object[0]);
                }
            } else {
                log.error("Don't know how to handle stats event " + event, new Object[0]);
            }
        }
    }

    private class StatisticCollector {
        Map<Operation, OperationStat> operationStatisticMap = new HashMap<Operation, OperationStat>();

        private StatisticCollector() {
        }

        public void addStatistic(Operation opeartion, Long duration, OperationStep operationStep) {
            OperationStat operationStatistic = this.operationStatisticMap.get((Object)opeartion);
            if (operationStatistic == null) {
                operationStatistic = new OperationStat();
                this.operationStatisticMap.put(opeartion, operationStatistic);
            }
            if (operationStep != OperationStep.NONE) {
                OperationStat nestedOperationStatistic = operationStatistic.subStatistics.get((Object)operationStep);
                if (nestedOperationStatistic == null) {
                    nestedOperationStatistic = new OperationStat();
                    operationStatistic.subStatistics.put(operationStep, nestedOperationStatistic);
                }
                operationStatistic = nestedOperationStatistic;
            }
            operationStatistic.minDuration = Math.min(operationStatistic.minDuration, duration);
            operationStatistic.maxDuration = Math.max(operationStatistic.maxDuration, duration);
            ++operationStatistic.numOperations;
            operationStatistic.totalDuration += duration.longValue();
        }

        public String generateReport() {
            StringBuilder sb = new StringBuilder("LexoRank Statistics Report\n");
            for (Operation operation : Operation.values()) {
                sb.append("Operation:" + (Object)((Object)operation));
                if (this.operationStatisticMap.containsKey((Object)operation)) {
                    OperationStat operationStatistic = this.operationStatisticMap.get((Object)operation);
                    sb.append(" num=" + operationStatistic.numOperations);
                    sb.append(";min=" + operationStatistic.minDuration + "ms");
                    sb.append(";avg=" + operationStatistic.totalDuration / (long)operationStatistic.numOperations + "ms");
                    sb.append(";max=" + operationStatistic.maxDuration + "ms");
                    if (operationStatistic.subStatistics.keySet().size() > 0) {
                        for (OperationStep operationStep : operationStatistic.subStatistics.keySet()) {
                            OperationStat stepStatistic = operationStatistic.subStatistics.get((Object)operationStep);
                            sb.append(" " + (Object)((Object)operationStep) + "=[");
                            sb.append("num=" + stepStatistic.numOperations);
                            sb.append(";min=" + stepStatistic.minDuration + "ms");
                            sb.append(";avg=" + stepStatistic.totalDuration / (long)stepStatistic.numOperations + "ms");
                            sb.append(";max=" + stepStatistic.maxDuration + "ms");
                            sb.append("]");
                        }
                    }
                } else {
                    sb.append(" no data");
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        class OperationStat {
            long minDuration = Long.MAX_VALUE;
            long maxDuration = Long.MIN_VALUE;
            int numOperations = 0;
            long totalDuration = 0L;
            Map<OperationStep, OperationStat> subStatistics = new HashMap<OperationStep, OperationStat>();

            OperationStat() {
            }
        }
    }

    @VisibleForTesting
    protected static class StatsEvent {
        final Thread thread = Thread.currentThread();
        final long time = System.currentTimeMillis();
        final Operation operation;
        final EventType eventType;
        final OperationStep operationStep;

        private StatsEvent(Operation operation, EventType eventType, OperationStep operationStep) {
            this.operation = operation;
            this.eventType = eventType;
            this.operationStep = operationStep;
        }

        public StatsEvent(Operation operation, EventType eventType) {
            this(operation, eventType, OperationStep.NONE);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        static enum EventType {
            START,
            END;

        }
    }

    public static enum OperationStep {
        NONE,
        BACKOFF_NONE,
        BACKOFF_YIELD,
        BACKOFF_SLEEP,
        HEAL_RANKVALUE;

    }

    public static enum Operation {
        RANK_BEFORE,
        RANK_AFTER,
        RANK_FIRST,
        RANK_LAST,
        MIN_TO_NEXT_BUCKET,
        MAX_TO_NEXT_BUCKET,
        RANK_INITIAL,
        REBALANCE_FIELDID,
        BALANCER_ENTRY_DELETE,
        BALANCER_ENTRY_SAVE,
        BALANCER_ENTRY_LIST,
        BALANCER_ENTRY_GET,
        DELETE_RANK_FOR_ISSUE,
        DELETE_RANKS_FOR_ISSUES;

    }
}

