/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class LexoRankOperationOutcome<T> {
    private final Set<Long> issueIdsToReIndex = Sets.newHashSet();
    private final T result;
    private ErrorCollection errorCollection;
    private boolean valid;

    private LexoRankOperationOutcome(T result, Set<Long> issueIdsToReIndex) {
        this.result = result;
        this.issueIdsToReIndex.addAll(issueIdsToReIndex);
        this.errorCollection = new ErrorCollection();
        this.valid = true;
    }

    private LexoRankOperationOutcome(ErrorCollection errorCollection) {
        this.result = null;
        this.errorCollection = errorCollection;
        this.valid = false;
    }

    public static <T> LexoRankOperationOutcome<T> ok(T result, Collection<Long> issueIdsToReIndex) {
        return new LexoRankOperationOutcome<T>(result, Sets.newHashSet(issueIdsToReIndex));
    }

    public static <T> LexoRankOperationOutcome<T> ok(T result, Long ... issueIdsToReIndex) {
        return new LexoRankOperationOutcome<T>(result, Sets.newHashSet((Object[])issueIdsToReIndex));
    }

    public static <T> LexoRankOperationOutcome<T> ok(T result) {
        return new LexoRankOperationOutcome<T>(result, Sets.newHashSet());
    }

    public static <T> LexoRankOperationOutcome<T> timeout() {
        return new LexoRankOperationOutcome<T>(ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.retrytimeout", new Object[0]).getErrors());
    }

    public static <T> LexoRankOperationOutcome<T> duplicateRank() {
        return new LexoRankOperationOutcome<T>(ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.duplicate", new Object[0]).getErrors());
    }

    public static <T> LexoRankOperationOutcome<T> reindexRequired() {
        return new LexoRankOperationOutcome<T>(ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.reindex.required", new Object[0]).getErrors());
    }

    public static <T> LexoRankOperationOutcome<T> error(ErrorCollection errorCollection) {
        return new LexoRankOperationOutcome<T>(errorCollection);
    }

    public static <T> LexoRankOperationOutcome<T> error(ErrorCollection.Reason reason, String messageKey, Object ... messageArguments) {
        return LexoRankOperationOutcome.error(new ErrorCollection().addError(reason, messageKey, messageArguments));
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public Set<Long> getIssueIdsToReIndex() {
        return this.issueIdsToReIndex;
    }

    public T getResult() {
        return this.result;
    }

    public ErrorCollection getErrors() {
        return this.errorCollection;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

