/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRowUtils;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.BackoffHandler;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankHealOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankSettings;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class LexoRankOperation {
    private static final LoggerWrapper LOG = LoggerWrapper.with(LexoRankOperation.class);
    public static final int LEXORANK_MAX_LENGTH = 254;
    private static final Map<RankOperationType, LexoRankStatisticsAgent.Operation> rankOperationToLexoOperationMap = Maps.newHashMap();
    private final LexoRankDao dao;
    private final LexoRankStatisticsAgent statisticsAgent;
    private final RankOperationType rankOperationType;
    private final Long issueToRankIssueId;
    private final Long issueToRankAroundIssueId;
    private final Long rankFieldId;
    private final Integer remainingRankOperations;

    private LexoRankOperation(LexoRankDao dao, LexoRankStatisticsAgent statisticsAgent, RankOperationType rankOperationType, Long issueToRankIssueId, Long issueToRankAroundIssueId, Long rankFieldId, Integer remainingRankOperations) {
        this.dao = dao;
        this.statisticsAgent = statisticsAgent;
        this.rankOperationType = rankOperationType;
        this.issueToRankIssueId = issueToRankIssueId;
        this.issueToRankAroundIssueId = issueToRankAroundIssueId;
        this.rankFieldId = rankFieldId;
        this.remainingRankOperations = remainingRankOperations;
    }

    public LexoRankOperationOutcome<LexoRankChange> execute() {
        LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome;
        this.logStartOfOperation();
        switch (this.rankOperationType) {
            case RANK_BEFORE: 
            case RANK_AFTER: {
                lexoRankOperationOutcome = this.rankRelativeToOtherIssue();
                break;
            }
            case RANK_FIRST: 
            case RANK_LAST: {
                lexoRankOperationOutcome = this.rankFirstOrLast();
                break;
            }
            case RANK_INITIAL: {
                lexoRankOperationOutcome = this.rankInitially();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rank operation type");
            }
        }
        this.logEndOfOperation();
        return lexoRankOperationOutcome;
    }

    private void logStartOfOperation() {
        LOG.debug("%s start [fieldId=%s, issueToRankIssueId=%s, issueToRankAroundIssueId=%s", new Object[]{this.rankOperationType, this.rankFieldId, this.issueToRankIssueId, this.issueToRankAroundIssueId});
        this.statisticsAgent.startOperation(rankOperationToLexoOperationMap.get((Object)this.rankOperationType));
    }

    private void logEndOfOperation() {
        LOG.debug("%s end   [fieldId=%s, issueToRankIssueId=%s, issueToRankAroundIssueId=%s", new Object[]{this.rankOperationType, this.rankFieldId, this.issueToRankIssueId, this.issueToRankAroundIssueId});
        this.statisticsAgent.endOperation(rankOperationToLexoOperationMap.get((Object)this.rankOperationType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<LexoRankChange> rankInitially() {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.RANK_INITIALLY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.statisticsAgent, timeoutTime);
        LOG.debug("Ranking issue [id=%s] initially for rank field[id=%s]", this.issueToRankIssueId, this.rankFieldId);
        while (System.currentTimeMillis() < timeoutTime) {
            Option<LexoRankRow> maybeRanked = this.dao.findByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
            if (maybeRanked.isDefined()) {
                LexoRankRow rankRow = (LexoRankRow)maybeRanked.get();
                LexoRank existingRank = LexoRank.parse(rankRow.getRank());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(this.rankFieldId).rankedIssue(this.issueToRankIssueId).noop(existingRank).build();
                LOG.debug("Issue [id=%s] already has a rank[%s] for rank field[id=%s]", this.issueToRankIssueId, rankRow.getRank(), this.rankFieldId);
                return LexoRankOperationOutcome.ok(lexoRankChange);
            }
            backoffHandler.maybeWait();
            LexoRankRow[] unlockedRankRows = this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId);
            LockOutcome lockOutcome = this.dao.acquireLock(unlockedRankRows);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock != null) {
                    this.dao.releaseLock(lock);
                }
                LOG.debug("Failed to acquire a lock on the max marker row and previous row for rank field[id=%s], retrying rank intially", this.rankFieldId);
                continue;
            }
            try {
                LexoRank initialRank;
                LexoRank lastRank;
                maybeRanked = this.dao.findByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
                if (maybeRanked.isDefined()) {
                    LexoRankRow rankRow = (LexoRankRow)maybeRanked.get();
                    LexoRank existingRank = LexoRank.parse(rankRow.getRank());
                    LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(this.rankFieldId).rankedIssue(this.issueToRankIssueId).noop(existingRank).build();
                    LOG.debug("Issue [id=%s] already has a rank[%s] for rank field[id=%s]", this.issueToRankIssueId, rankRow.getRank(), this.rankFieldId);
                    LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(lexoRankChange);
                    return lexoRankOperationOutcome;
                }
                LexoRankRow[] rankRows = this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId);
                if (LexoRankRowUtils.areRowsDifferent(unlockedRankRows, rankRows)) {
                    LOG.debug("Max marker row and previous row for rank field[id=%s] have changed since acquiring a lock on them, retrying rank initially", this.rankFieldId);
                    continue;
                }
                LexoRankRow maximumMarkerRow = rankRows[0];
                LexoRankRow previousRankRow = rankRows[1];
                if (previousRankRow.getType().equals((Object)LexoRankRow.RankRowType.MINIMUM_MARKER_ROW)) {
                    lastRank = LexoRank.parse(maximumMarkerRow.getRank());
                    initialRank = LexoRank.from(lastRank.getBucket(), LexoRank.MID_DECIMAL);
                } else {
                    lastRank = LexoRank.parse(rankRows[1].getRank());
                    initialRank = lastRank.genNext();
                }
                boolean rankExistsForFieldId = this.dao.existsRankForFieldId(this.rankFieldId, initialRank.format());
                if (rankExistsForFieldId) {
                    LOG.debug("Initial rank[%s] for issue[id=%s] for rank field[id=%s] already exists, retrying rank initially", initialRank.format(), this.issueToRankIssueId, this.rankFieldId);
                    continue;
                }
                if (this.exceedsMaxRankLength(initialRank)) {
                    LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome = LexoRankOperationOutcome.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.lexorank.fieldlength.exceeded.norebalance", new Object[0]);
                    return lexoRankOperationOutcome;
                }
                LexoRankRow newRankRow = this.dao.create(this.rankFieldId, this.issueToRankIssueId, initialRank.format());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(this.rankFieldId).rankedIssue(this.issueToRankIssueId).initially(LexoRank.parse(newRankRow.getRank())).build();
                LOG.debug("Ranked issue[id=%s] initially with rank[%s] for rank field[id=%s]", this.issueToRankIssueId, newRankRow.getRank(), this.rankFieldId);
                LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(lexoRankChange, Lists.newArrayList((Object[])new Long[]{this.issueToRankIssueId}));
                return lexoRankOperationOutcome;
            }
            finally {
                this.dao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<LexoRankChange> rankRelativeToOtherIssue() {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.RANK_RETRY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.statisticsAgent, timeoutTime);
        HashSet issueIdsToReIndex = Sets.newHashSet();
        LOG.debug("Ranking issue[id=%s] relative to issue[id=%s] for rank field[id=%s]. RankOperationType[%s]", this.issueToRankIssueId, this.issueToRankAroundIssueId, this.rankFieldId, this.rankOperationType.name());
        while (System.currentTimeMillis() < timeoutTime) {
            LexoRankRow[] unlockedLexoRankRows;
            backoffHandler.maybeWait();
            Option<LexoRankRow> maybeUnlockedRankRow = this.dao.findByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
            if (maybeUnlockedRankRow.isEmpty()) {
                return LexoRankOperationOutcome.reindexRequired();
            }
            LexoRankRow unlockedRankRow = (LexoRankRow)maybeUnlockedRankRow.get();
            if (this.issueToRankIssueId.equals(this.issueToRankAroundIssueId)) {
                LexoRank existingRank = LexoRank.parse(unlockedRankRow.getRank());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(this.rankFieldId).rankedIssue(this.issueToRankIssueId).noop(existingRank).build();
                return LexoRankOperationOutcome.ok(lexoRankChange, issueIdsToReIndex);
            }
            Option<LexoRankRow> maybeUnlockedOtherRankRow = this.dao.findByFieldAndIssueId(this.rankFieldId, this.issueToRankAroundIssueId);
            if (maybeUnlockedOtherRankRow.isEmpty()) {
                return LexoRankOperationOutcome.reindexRequired();
            }
            LexoRankRow unlockedOtherRankRow = (LexoRankRow)maybeUnlockedOtherRankRow.get();
            LexoRankRow[] lexoRankRowArray = unlockedLexoRankRows = this.rankOperationType.equals((Object)RankOperationType.RANK_BEFORE) ? this.dao.getRowByRankAndPreviousRow(this.rankFieldId, unlockedOtherRankRow.getRank()) : this.dao.getRowByRankAndNextRow(this.rankFieldId, unlockedOtherRankRow.getRank());
            if (unlockedLexoRankRows.length < 2) continue;
            LexoRankHealOperation healOperation = LexoRankHealOperation.builder(this.dao, this.statisticsAgent).forRankField(this.rankFieldId).heal(unlockedRankRow, unlockedLexoRankRows[0], unlockedLexoRankRows[1]).build();
            LexoRankOperationOutcome<Boolean> healOperationOutcome = healOperation.execute();
            if (healOperationOutcome.isValid() && healOperationOutcome.getResult().booleanValue()) {
                issueIdsToReIndex.addAll(healOperationOutcome.getIssueIdsToReIndex());
                LOG.debug("Healed duplicate ranks for issues[ids=%s] for rank field[id=%s], retrying rank operation", StringUtils.join(healOperationOutcome.getIssueIdsToReIndex(), (String)","), this.rankFieldId);
                continue;
            }
            if (LexoRankRowUtils.areRowsDifferent(unlockedOtherRankRow, unlockedLexoRankRows[0])) {
                LOG.debug("Rank rows have changed for rank field[id=%s], retrying rank operation", this.rankFieldId);
                continue;
            }
            if (this.issueToRankIssueId.equals(unlockedLexoRankRows[1].getIssueId())) {
                LexoRank existingRank = LexoRank.parse(unlockedLexoRankRows[1].getRank());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(this.rankFieldId).rankedIssue(this.issueToRankIssueId).noop(existingRank).build();
                return LexoRankOperationOutcome.ok(lexoRankChange, issueIdsToReIndex);
            }
            LexoRank rankBetweenFrom = LexoRank.parse(unlockedLexoRankRows[0].getRank());
            LexoRank rankBetweenTo = LexoRank.parse(unlockedLexoRankRows[1].getRank());
            if (!rankBetweenFrom.getBucket().equals((Object)rankBetweenTo.getBucket())) {
                LOG.debug("Rank rows to rank between (%s, %s) for rank field[id=%s] are in different buckets, retrying rank operation", rankBetweenFrom, rankBetweenTo, this.rankFieldId);
                continue;
            }
            HashSet rowsToLock = Sets.newHashSet((Object[])new LexoRankRow[]{unlockedRankRow, unlockedLexoRankRows[0], unlockedLexoRankRows[1]});
            LockOutcome lockOutcome = this.dao.acquireLock(rowsToLock);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock != null) {
                    this.dao.releaseLock(lock);
                }
                LOG.debug("Failed to acquire a lock on the rank rows for rank field[id=%s], retrying rank operation", this.rankFieldId);
                continue;
            }
            try {
                LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome;
                Optional<LexoRankOperationOutcome<LexoRankChange>> outcomeOptional;
                LexoRankRow rankRow = this.dao.getByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
                if (LexoRankRowUtils.areRowsDifferent(unlockedRankRow, rankRow)) {
                    LOG.debug("Rank row of issue[id=%s] for rank field[id=%s] being ranked has changed since acquiring a lock, retrying rank operation", this.issueToRankIssueId, this.rankFieldId);
                    continue;
                }
                LexoRankRow[] unlockedLexoRankRowsSorted = (LexoRankRow[])Stream.of(unlockedLexoRankRows).sorted(Comparator.comparing(LexoRankRow::getRank)).toArray(LexoRankRow[]::new);
                LexoRankRow[] lockedRankRows = this.dao.getRowByRankAndNextRow(this.rankFieldId, unlockedLexoRankRowsSorted[0].getRank());
                if (LexoRankRowUtils.areRowsDifferent(lockedRankRows, unlockedLexoRankRowsSorted)) {
                    LOG.debug("Rank rows being ranked for rank field[id=%s] between have changed since acquiring a lock, retrying rank operation", this.rankFieldId);
                    continue;
                }
                if (rankRow.getRank().compareTo(lockedRankRows[0].getRank()) < 0) {
                    LOG.debug("IssueToRank(rank = {}) is above target location(rank = {}). Checking if they are neighbours", rankRow.getRank(), lockedRankRows[0].getRank());
                    LexoRankRow[] prevNeighbours = this.dao.getRowByRankAndNextRow(this.rankFieldId, rankRow.getRank());
                    if (prevNeighbours.length > 1 && prevNeighbours[0].equals(rankRow) && prevNeighbours[1].equals(lockedRankRows[0])) {
                        LOG.debug("Detected neighbours: switching ranks between issues: {} and {}", rankRow.getIssueId(), prevNeighbours[1].getIssueId());
                        outcomeOptional = this.swapRanks(lock, rankRow, prevNeighbours[1], issueIdsToReIndex);
                        if (!outcomeOptional.isPresent()) continue;
                        lexoRankOperationOutcome = outcomeOptional.get();
                        return lexoRankOperationOutcome;
                    }
                } else {
                    LOG.debug("IssueToRank(rank = {}) is below target location(rank = {}). Checking if they are neighbours", rankRow.getRank(), lockedRankRows[1].getRank());
                    LexoRankRow[] nextNeighbours = this.dao.getRowByRankAndNextRow(this.rankFieldId, lockedRankRows[1].getRank());
                    if (nextNeighbours.length > 1 && nextNeighbours[0].equals(lockedRankRows[1]) && nextNeighbours[1].equals(rankRow)) {
                        LOG.debug("Detected neighbours: switching ranks between issues: {} and {}", rankRow.getIssueId(), nextNeighbours[0].getIssueId());
                        outcomeOptional = this.swapRanks(lock, rankRow, nextNeighbours[0], issueIdsToReIndex);
                        if (!outcomeOptional.isPresent()) continue;
                        lexoRankOperationOutcome = outcomeOptional.get();
                        return lexoRankOperationOutcome;
                    }
                }
                LexoRank newRank = this.getRankRelativeToOtherIssue(lockedRankRows);
                rankRow.setRank(newRank.format());
                boolean existsRankForFieldId = this.dao.existsRankForFieldId(this.rankFieldId, newRank.format());
                if (existsRankForFieldId) {
                    LOG.debug("New rank[%s] for issue[id=%s] for rank field[id=%s] already exists, aborting rank operation", newRank.format(), this.issueToRankIssueId, this.rankFieldId);
                    lexoRankOperationOutcome = LexoRankOperationOutcome.duplicateRank();
                    return lexoRankOperationOutcome;
                }
                if (this.exceedsMaxRankLength(newRank)) {
                    lexoRankOperationOutcome = LexoRankOperationOutcome.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.lexorank.fieldlength.exceeded.norebalance", new Object[0]);
                    return lexoRankOperationOutcome;
                }
                LockProcessOutcome<ServiceOutcome<LexoRankRow>> saveProcessOutcome = this.dao.save(lock, rankRow);
                if (saveProcessOutcome.isRetry()) {
                    LOG.debug("Save of rank row [%s] failed, retrying rank operation", rankRow.toString());
                    continue;
                }
                ServiceOutcome<LexoRankRow> saveOutcome = saveProcessOutcome.get();
                if (saveOutcome.isInvalid()) {
                    LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome2 = LexoRankOperationOutcome.error(saveOutcome.getErrors());
                    return lexoRankOperationOutcome2;
                }
                LexoRankRow savedRow = saveOutcome.get();
                Long savedRankFieldId = savedRow.getFieldId();
                Long savedIssueId = savedRow.getIssueId();
                LexoRank oldRank = LexoRank.parse(unlockedRankRow.getRank());
                LexoRank savedRank = LexoRank.parse(savedRow.getRank());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(savedRankFieldId).rankedIssue(savedIssueId).from(oldRank).to(savedRank).build();
                issueIdsToReIndex.add(this.issueToRankIssueId);
                LOG.debug("Ranked issue[id=%s] relative to issue[%s] with new rank[%s] for rank field[id=%s]", this.issueToRankIssueId, this.issueToRankAroundIssueId, rankRow.getRank(), this.rankFieldId);
                LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome3 = LexoRankOperationOutcome.ok(lexoRankChange, issueIdsToReIndex);
                return lexoRankOperationOutcome3;
            }
            finally {
                this.dao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    private Optional<LexoRankOperationOutcome<LexoRankChange>> swapRanks(Lock lock, LexoRankRow masterRow, LexoRankRow slaveRow, Collection<Long> issueIdsToReIndex) {
        LexoRank oldSlaveRank = LexoRank.parse(slaveRow.getRank());
        LexoRank oldMasterRank = LexoRank.parse(masterRow.getRank());
        LexoRank between = oldSlaveRank.between(oldMasterRank);
        masterRow.setRank(between.format());
        LockProcessOutcome<ServiceOutcome<LexoRankRow>> betweenSaveResult = this.dao.save(lock, masterRow);
        if (betweenSaveResult.isRetry()) {
            return Optional.empty();
        }
        ServiceOutcome<LexoRankRow> betweenOutcome = betweenSaveResult.get();
        if (betweenOutcome.isInvalid()) {
            return Optional.of(LexoRankOperationOutcome.error(betweenOutcome.getErrors()));
        }
        slaveRow.setRank(oldMasterRank.format());
        LockProcessOutcome<ServiceOutcome<LexoRankRow>> slaveSaveResults = this.dao.save(lock, slaveRow);
        if (slaveSaveResults.isRetry()) {
            return Optional.empty();
        }
        ServiceOutcome<LexoRankRow> slaveOutcome = slaveSaveResults.get();
        if (slaveOutcome.isInvalid()) {
            LOG.info("LexoRank space was narrowed by unsuccessful rank swap of issues: [%s] and [%s]", masterRow.getIssueId(), slaveRow.getIssueId());
            return Optional.of(LexoRankOperationOutcome.error(slaveOutcome.getErrors()));
        }
        masterRow.setRank(oldSlaveRank.format());
        LockProcessOutcome<ServiceOutcome<LexoRankRow>> masterSaveResult = this.dao.save(lock, masterRow);
        issueIdsToReIndex.add(masterRow.getIssueId());
        issueIdsToReIndex.add(slaveRow.getIssueId());
        ServiceOutcome<LexoRankRow> masterOutcome = masterSaveResult.get();
        if (masterOutcome.isInvalid()) {
            LOG.info("LexoRank space was narrowed by rank swap of issues: [%s] and [%s]", masterRow.getIssueId(), slaveRow.getIssueId());
            return Optional.of(LexoRankOperationOutcome.ok(this.createLexoRankChange(oldMasterRank, betweenOutcome.get()), issueIdsToReIndex));
        }
        return Optional.of(LexoRankOperationOutcome.ok(this.createLexoRankChange(oldMasterRank, masterOutcome.get()), issueIdsToReIndex));
    }

    private LexoRankChange createLexoRankChange(LexoRank oldRank, LexoRankRow savedRow) {
        Long savedRankFieldId = savedRow.getFieldId();
        Long savedIssueId = savedRow.getIssueId();
        LexoRank savedRank = LexoRank.parse(savedRow.getRank());
        return LexoRankChange.builder().forRankField(savedRankFieldId).rankedIssue(savedIssueId).from(oldRank).to(savedRank).build();
    }

    private LexoRank getRankRelativeToOtherIssue(LexoRankRow[] lockedSurroundingRankRows) {
        LexoRank lowerRank = LexoRank.parse(lockedSurroundingRankRows[0].getRank());
        LexoRank higherRank = LexoRank.parse(lockedSurroundingRankRows[1].getRank());
        LexoRank relativeRank = higherRank.isMax() ? lowerRank.genNext() : (lowerRank.isMin() ? higherRank.genPrev() : lowerRank.between(higherRank, this.remainingRankOperations));
        return relativeRank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<LexoRankChange> rankFirstOrLast() {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.RANK_RETRY_TIMEOUT_MS;
        HashSet issueIdsToReIndex = Sets.newHashSet();
        BackoffHandler backoffHandler = new BackoffHandler(this.statisticsAgent, timeoutTime);
        LOG.debug("Ranking issue[id=%s] first/last for rank field[id=%s]. RankOperationType[%s]", this.issueToRankIssueId, this.rankFieldId, this.rankOperationType.name());
        while (System.currentTimeMillis() < timeoutTime) {
            backoffHandler.maybeWait();
            Option<LexoRankRow> maybeUnlockedLexoRankRow = this.dao.findByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
            if (maybeUnlockedLexoRankRow.isEmpty()) {
                return LexoRankOperationOutcome.reindexRequired();
            }
            LexoRankRow unlockedLexoRankRow = (LexoRankRow)maybeUnlockedLexoRankRow.get();
            LexoRankRow[] unlockedLexoRankRows = this.rankOperationType.equals((Object)RankOperationType.RANK_FIRST) ? this.dao.getMinimumMarkerRowAndNextRow(this.rankFieldId) : this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId);
            LexoRankHealOperation healOperation = LexoRankHealOperation.builder(this.dao, this.statisticsAgent).forRankField(this.rankFieldId).heal(unlockedLexoRankRow, unlockedLexoRankRows[0], unlockedLexoRankRows[1]).build();
            LexoRankOperationOutcome<Boolean> healOperationOutcome = healOperation.execute();
            if (healOperationOutcome.isValid() && healOperationOutcome.getResult().booleanValue()) {
                issueIdsToReIndex.addAll(healOperationOutcome.getIssueIdsToReIndex());
                LOG.debug("Healed duplicate ranks for issues[ids=%s] for rank field[id=%s], retrying rank operation", StringUtils.join(healOperationOutcome.getIssueIdsToReIndex(), (String)","), this.rankFieldId);
                continue;
            }
            LexoRank rankBetweenFrom = LexoRank.parse(unlockedLexoRankRows[0].getRank());
            LexoRank rankBetweenTo = LexoRank.parse(unlockedLexoRankRows[1].getRank());
            if (!rankBetweenFrom.getBucket().equals((Object)rankBetweenTo.getBucket())) {
                LOG.debug("Rank rows to rank between (%s, %s) for rank field[id=%s] are in different buckets, retrying rank operation", rankBetweenFrom, rankBetweenTo, this.rankFieldId);
                continue;
            }
            HashSet lexoRankRowsToLock = Sets.newHashSet((Object[])new LexoRankRow[]{unlockedLexoRankRow, unlockedLexoRankRows[0], unlockedLexoRankRows[1]});
            LockOutcome lockOutcome = this.dao.acquireLock(lexoRankRowsToLock);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock != null) {
                    this.dao.releaseLock(lock);
                }
                LOG.debug("Failed to acquire a lock on the rank rows for rank field[id=%s], retrying rank operation", this.rankFieldId);
                continue;
            }
            try {
                LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome;
                LexoRankRow[] lockedRankRows;
                LexoRankRow rankRow = this.dao.getByFieldAndIssueId(this.rankFieldId, this.issueToRankIssueId);
                if (LexoRankRowUtils.areRowsDifferent(unlockedLexoRankRow, rankRow)) {
                    LOG.debug("Rank row of issue[id=%s] for rank field[id=%s] being ranked has changed since acquiring a lock, retrying rank operation", this.issueToRankIssueId, this.rankFieldId);
                    continue;
                }
                LexoRankRow[] lexoRankRowArray = lockedRankRows = this.rankOperationType.equals((Object)RankOperationType.RANK_FIRST) ? this.dao.getMinimumMarkerRowAndNextRow(this.rankFieldId) : this.dao.getMaximumMarkerRowAndPreviousRow(this.rankFieldId);
                if (LexoRankRowUtils.areRowsDifferent(lockedRankRows, unlockedLexoRankRows)) {
                    LOG.debug("Rank rows being ranked between for rank field[id=%s] have changed since acquiring a lock, retrying rank operation", this.rankFieldId);
                    continue;
                }
                LexoRank rankAdjacentToMarkerRow = LexoRank.parse(lockedRankRows[1].getRank());
                LexoRank newRank = this.rankOperationType.equals((Object)RankOperationType.RANK_FIRST) ? rankAdjacentToMarkerRow.genPrev() : rankAdjacentToMarkerRow.genNext();
                rankRow.setRank(newRank.format());
                boolean existsRankForFieldId = this.dao.existsRankForFieldId(this.rankFieldId, newRank.format());
                if (existsRankForFieldId) {
                    LOG.debug("New rank[%s] for issue[id=%s] for rank field[id=%s] already exists, aborting rank operation", newRank.format(), this.issueToRankIssueId, this.rankFieldId);
                    lexoRankOperationOutcome = LexoRankOperationOutcome.duplicateRank();
                    return lexoRankOperationOutcome;
                }
                if (this.exceedsMaxRankLength(newRank)) {
                    lexoRankOperationOutcome = LexoRankOperationOutcome.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.lexorank.fieldlength.exceeded.norebalance", new Object[0]);
                    return lexoRankOperationOutcome;
                }
                LockProcessOutcome<ServiceOutcome<LexoRankRow>> saveProcessOutcome = this.dao.save(lock, rankRow);
                if (saveProcessOutcome.isRetry()) {
                    LOG.debug("Save of rank row [%s] failed, retrying rank operation", rankRow.toString());
                    continue;
                }
                ServiceOutcome<LexoRankRow> saveOutcome = saveProcessOutcome.get();
                if (saveOutcome.isInvalid()) {
                    LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome2 = LexoRankOperationOutcome.error(saveOutcome.getErrors());
                    return lexoRankOperationOutcome2;
                }
                LexoRankRow savedRow = saveOutcome.get();
                Long savedRankFieldId = savedRow.getFieldId();
                Long savedIssueId = savedRow.getIssueId();
                LexoRank oldRank = LexoRank.parse(unlockedLexoRankRow.getRank());
                LexoRank savedRank = LexoRank.parse(savedRow.getRank());
                LexoRankChange lexoRankChange = LexoRankChange.builder().forRankField(savedRankFieldId).rankedIssue(savedIssueId).from(oldRank).to(savedRank).build();
                issueIdsToReIndex.add(this.issueToRankIssueId);
                LOG.debug("Ranked issue[id=%s] first/last with new rank[%s] for rank field[id=%s]", this.issueToRankIssueId, this.issueToRankAroundIssueId, rankRow.getRank(), this.rankFieldId);
                LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome3 = LexoRankOperationOutcome.ok(lexoRankChange, issueIdsToReIndex);
                return lexoRankOperationOutcome3;
            }
            finally {
                this.dao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    private boolean exceedsMaxRankLength(LexoRank rank) {
        return rank.format().length() > 254;
    }

    public static IssueToRank builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
        return new Builder(lexoRankDao, lexoRankStatisticsAgent);
    }

    static {
        rankOperationToLexoOperationMap.put(RankOperationType.RANK_BEFORE, LexoRankStatisticsAgent.Operation.RANK_BEFORE);
        rankOperationToLexoOperationMap.put(RankOperationType.RANK_AFTER, LexoRankStatisticsAgent.Operation.RANK_AFTER);
        rankOperationToLexoOperationMap.put(RankOperationType.RANK_FIRST, LexoRankStatisticsAgent.Operation.RANK_FIRST);
        rankOperationToLexoOperationMap.put(RankOperationType.RANK_LAST, LexoRankStatisticsAgent.Operation.RANK_LAST);
        rankOperationToLexoOperationMap.put(RankOperationType.RANK_INITIAL, LexoRankStatisticsAgent.Operation.RANK_INITIAL);
    }

    public static interface CompleteRankOperation {
        public LexoRankOperation build();

        public CompleteRankOperation withRemainingRankOperations(int var1);
    }

    public static interface ForRankField {
        public CompleteRankOperation forRankField(Long var1);
    }

    public static interface HowToRankIssue {
        public ForRankField beforeIssue(Long var1);

        public ForRankField afterIssue(Long var1);

        public ForRankField first();

        public ForRankField last();

        public ForRankField initial();
    }

    public static interface IssueToRank {
        public HowToRankIssue rankIssue(Long var1);
    }

    public static class Builder
    implements IssueToRank,
    HowToRankIssue,
    ForRankField,
    CompleteRankOperation {
        private LexoRankDao lexoRankDao;
        private LexoRankStatisticsAgent lexoRankStatisticsAgent;
        private RankOperationType rankOperationType;
        private Long issueToRankIssueId;
        private Long issueToRankAroundIssueId;
        private Long rankFieldId;
        private Integer remainingRankOperations = 0;

        private Builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
            this.lexoRankDao = lexoRankDao;
            this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        }

        @Override
        public LexoRankOperation build() {
            return new LexoRankOperation(this.lexoRankDao, this.lexoRankStatisticsAgent, this.rankOperationType, this.issueToRankIssueId, this.issueToRankAroundIssueId, this.rankFieldId, this.remainingRankOperations);
        }

        @Override
        public CompleteRankOperation withRemainingRankOperations(int remainingRankOperations) {
            this.remainingRankOperations = remainingRankOperations;
            return this;
        }

        @Override
        public CompleteRankOperation forRankField(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        @Override
        public HowToRankIssue rankIssue(Long issueId) {
            this.issueToRankIssueId = issueId;
            return this;
        }

        @Override
        public ForRankField beforeIssue(Long issueId) {
            this.rankOperationType = RankOperationType.RANK_BEFORE;
            this.issueToRankAroundIssueId = issueId;
            return this;
        }

        @Override
        public ForRankField afterIssue(Long issueId) {
            this.rankOperationType = RankOperationType.RANK_AFTER;
            this.issueToRankAroundIssueId = issueId;
            return this;
        }

        @Override
        public ForRankField first() {
            this.rankOperationType = RankOperationType.RANK_FIRST;
            return this;
        }

        @Override
        public ForRankField last() {
            this.rankOperationType = RankOperationType.RANK_LAST;
            return this;
        }

        @Override
        public ForRankField initial() {
            this.rankOperationType = RankOperationType.RANK_INITIAL;
            return this;
        }
    }

    public static enum RankOperationType {
        RANK_BEFORE,
        RANK_AFTER,
        RANK_FIRST,
        RANK_LAST,
        RANK_INITIAL;

    }
}

